/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.airlift.json.JsonCodec;
import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.JsonResponse;
import io.trino.jdbc.$internal.client.ServerInfo;
import io.trino.jdbc.$internal.client.StatementClient;
import io.trino.jdbc.$internal.client.StatementClientFactory;
import io.trino.jdbc.$internal.okhttp3.HttpUrl;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import java.net.URI;
import java.util.Objects;

class QueryExecutor {
    private static final JsonCodec<ServerInfo> SERVER_INFO_CODEC = JsonCodec.jsonCodec(ServerInfo.class);
    private final OkHttpClient httpClient;

    public QueryExecutor(OkHttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
    }

    public StatementClient startQuery(.ClientSession session, String query) {
        return StatementClientFactory.newStatementClient(this.httpClient, session, query);
    }

    public ServerInfo getServerInfo(URI server) {
        HttpUrl url = HttpUrl.get(server);
        if (url == null) {
            throw new ClientException("Invalid server URL: " + server);
        }
        .Request request = new .Request.Builder().url(url = url.newBuilder().encodedPath("/v1/info").build()).build();
        JsonResponse<ServerInfo> response = JsonResponse.execute(SERVER_INFO_CODEC, this.httpClient, request);
        if (!response.hasValue()) {
            throw new RuntimeException(String.format("Request to %s failed: %s [Error: %s]", server, response, response.getResponseBody()));
        }
        return response.getValue();
    }
}

