/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.jackson.datatype.jsr310.deser;

import io.trino.jdbc.$internal.jackson.annotation.JsonFormat;
import io.trino.jdbc.$internal.jackson.core.JsonParser;
import io.trino.jdbc.$internal.jackson.core.JsonToken;
import io.trino.jdbc.$internal.jackson.databind.BeanProperty;
import io.trino.jdbc.$internal.jackson.databind.DeserializationContext;
import io.trino.jdbc.$internal.jackson.databind.JsonDeserializer;
import io.trino.jdbc.$internal.jackson.databind.JsonMappingException;
import io.trino.jdbc.$internal.jackson.databind.deser.ContextualDeserializer;
import io.trino.jdbc.$internal.jackson.databind.jsontype.TypeDeserializer;
import io.trino.jdbc.$internal.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class JSR310StringParsableDeserializer
extends JSR310DeserializerBase<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected static final int TYPE_PERIOD = 1;
    protected static final int TYPE_ZONE_ID = 2;
    protected static final int TYPE_ZONE_OFFSET = 3;
    public static final JsonDeserializer<Period> PERIOD = JSR310StringParsableDeserializer.createDeserializer(Period.class, 1);
    public static final JsonDeserializer<ZoneId> ZONE_ID = JSR310StringParsableDeserializer.createDeserializer(ZoneId.class, 2);
    public static final JsonDeserializer<ZoneOffset> ZONE_OFFSET = JSR310StringParsableDeserializer.createDeserializer(ZoneOffset.class, 3);
    protected final int _typeSelector;

    protected JSR310StringParsableDeserializer(Class<?> supportedType, int typeSelector) {
        super(supportedType);
        this._typeSelector = typeSelector;
    }

    protected JSR310StringParsableDeserializer(JSR310StringParsableDeserializer base, Boolean leniency) {
        super(base, leniency);
        this._typeSelector = base._typeSelector;
    }

    protected static <T> JsonDeserializer<T> createDeserializer(Class<T> type, int typeId) {
        return new JSR310StringParsableDeserializer(type, typeId);
    }

    protected JSR310StringParsableDeserializer withLeniency(Boolean leniency) {
        if (this._isLenient == !Boolean.FALSE.equals(leniency)) {
            return this;
        }
        return new JSR310StringParsableDeserializer(this, leniency);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext context) throws IOException {
        String string = p.getValueAsString();
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                if (!this.isLenient()) {
                    return this._failForNotLenient(p, context, JsonToken.VALUE_STRING);
                }
                return null;
            }
            try {
                switch (this._typeSelector) {
                    case 1: {
                        return Period.parse(string);
                    }
                    case 2: {
                        return ZoneId.of(string);
                    }
                    case 3: {
                        return ZoneOffset.of(string);
                    }
                }
            }
            catch (DateTimeException e) {
                return this._handleDateTimeException(context, e, string);
            }
        }
        if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return p.getEmbeddedObject();
        }
        if (p.hasToken(JsonToken.START_ARRAY)) {
            return this._deserializeFromArray(p, context);
        }
        throw context.wrongTokenException(p, this.handledType(), JsonToken.VALUE_STRING, null);
    }

    @Override
    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer deserializer) throws IOException {
        JsonToken t = parser.getCurrentToken();
        if (t != null && t.isScalarValue()) {
            return this.deserialize(parser, context);
        }
        return deserializer.deserializeTypedFromAny(parser, context);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        Boolean leniency;
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        JSR310StringParsableDeserializer deser = this;
        if (format != null && format.hasLenient() && (leniency = format.getLenient()) != null) {
            deser = this.withLeniency(leniency);
        }
        return deser;
    }
}

