/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.metadata.dialect;

import io.shardingsphere.core.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.core.metadata.AbstractRefreshHandler;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public final class JDBCShardingRefreshHandler
extends AbstractRefreshHandler {
    private ShardingConnection shardingConnection;

    private JDBCShardingRefreshHandler(ShardingConnection shardingConnection, SQLRouteResult routeResult, ShardingMetaData shardingMetaData, ShardingRule shardingRule) {
        super(routeResult, shardingMetaData, shardingRule);
        this.shardingConnection = shardingConnection;
    }

    public void execute() throws SQLException {
        if (this.getRouteResult().canRefreshMetaData()) {
            String logicTable = this.getRouteResult().getSqlStatement().getTables().getSingleTableName();
            Map<String, Connection> connectionMap = this.getConnectionMap(this.getShardingRule().getTableRule(logicTable));
            this.getShardingMetaData().refresh(this.getShardingRule().getTableRule(logicTable), this.getShardingRule(), connectionMap);
        }
    }

    private Map<String, Connection> getConnectionMap(TableRule tableRule) throws SQLException {
        HashMap<String, Connection> connectionMap = new HashMap<String, Connection>();
        for (DataNode each : tableRule.getActualDataNodes()) {
            String dataSourceName = this.getShardingRule().getShardingDataSourceNames().getRawMasterDataSourceName(each.getDataSourceName());
            connectionMap.put(dataSourceName, this.shardingConnection.getConnection(dataSourceName));
        }
        return connectionMap;
    }

    public static JDBCShardingRefreshHandler build(SQLRouteResult routeResult, ShardingConnection connection) {
        return new JDBCShardingRefreshHandler(connection, routeResult, connection.getShardingContext().getShardingMetaData(), connection.getShardingContext().getShardingRule());
    }
}

