/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.metadata.dialect;

import io.shardingsphere.core.jdbc.metadata.dialect.ShardingMetaDataHandler;
import io.shardingsphere.core.metadata.ColumnMetaData;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;

public final class H2ShardingMetaDataHandler
extends ShardingMetaDataHandler {
    public H2ShardingMetaDataHandler(DataSource dataSource, String actualTableName) {
        super(dataSource, actualTableName);
    }

    @Override
    public boolean isTableExist(Connection connection) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(null, null, this.getActualTableName(), null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Override
    public List<ColumnMetaData> getExistColumnMeta(Connection connection) throws SQLException {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        try (Statement statement = connection.createStatement();){
            statement.executeQuery(String.format("show columns from %s;", this.getActualTableName()));
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    result.add(new ColumnMetaData(resultSet.getString("FIELD"), resultSet.getString("TYPE"), resultSet.getString("KEY")));
                }
            }
            LinkedList<ColumnMetaData> linkedList = result;
            return linkedList;
        }
    }
}

