/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.metadata;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.jdbc.metadata.dialect.DefaultShardingMetaDataHandler;
import io.shardingsphere.core.jdbc.metadata.dialect.H2ShardingMetaDataHandler;
import io.shardingsphere.core.jdbc.metadata.dialect.MySQLShardingMetaDataHandler;
import io.shardingsphere.core.jdbc.metadata.dialect.ShardingMetaDataHandler;
import javax.sql.DataSource;

public final class ShardingMetaDataHandlerFactory {
    public static ShardingMetaDataHandler newInstance(DataSource dataSource, String actualTableName, DatabaseType databaseType) {
        switch (databaseType) {
            case MySQL: {
                return new MySQLShardingMetaDataHandler(dataSource, actualTableName);
            }
            case H2: {
                return new H2ShardingMetaDataHandler(dataSource, actualTableName);
            }
        }
        return new DefaultShardingMetaDataHandler(dataSource, actualTableName);
    }

    public static ShardingMetaDataHandler newInstance(String actualTableName, DatabaseType databaseType) {
        return ShardingMetaDataHandlerFactory.newInstance(null, actualTableName, databaseType);
    }

    private ShardingMetaDataHandlerFactory() {
    }
}

