/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.connection;

import io.shardingsphere.core.jdbc.adapter.AbstractConnectionAdapter;
import io.shardingsphere.core.jdbc.core.ShardingContext;
import io.shardingsphere.core.jdbc.core.statement.ShardingPreparedStatement;
import io.shardingsphere.core.jdbc.core.statement.ShardingStatement;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingConnection
extends AbstractConnectionAdapter {
    private final ShardingContext shardingContext;

    @Override
    protected Map<String, DataSource> getDataSourceMap() {
        return this.shardingContext.getDataSourceMap();
    }

    public void release(Connection connection) {
        this.removeCache(connection);
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection(this.shardingContext.getDataSourceMap().keySet().iterator().next()).getMetaData();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        return new ShardingPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return new ShardingPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public Statement createStatement() {
        return new ShardingStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @ConstructorProperties(value={"shardingContext"})
    public ShardingConnection(ShardingContext shardingContext) {
        this.shardingContext = shardingContext;
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }
}

