/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.type.prepared;

import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.BaseStatementUnit;
import io.shardingsphere.core.executor.ExecuteCallback;
import io.shardingsphere.core.executor.ExecutorEngine;
import io.shardingsphere.core.executor.type.prepared.PreparedStatementUnit;
import java.beans.ConstructorProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public final class PreparedStatementExecutor {
    private final ExecutorEngine executorEngine;
    private final SQLType sqlType;
    private final Collection<PreparedStatementUnit> preparedStatementUnits;

    public List<ResultSet> executeQuery() throws SQLException {
        return this.executorEngine.execute(this.sqlType, this.preparedStatementUnits, new ExecuteCallback<ResultSet>(){

            @Override
            public ResultSet execute(BaseStatementUnit baseStatementUnit) throws Exception {
                return ((PreparedStatement)baseStatementUnit.getStatement()).executeQuery();
            }
        });
    }

    public int executeUpdate() throws SQLException {
        List<Integer> results = this.executorEngine.execute(this.sqlType, this.preparedStatementUnits, new ExecuteCallback<Integer>(){

            @Override
            public Integer execute(BaseStatementUnit baseStatementUnit) throws Exception {
                return ((PreparedStatement)baseStatementUnit.getStatement()).executeUpdate();
            }
        });
        return this.accumulate(results);
    }

    private int accumulate(List<Integer> results) {
        int result = 0;
        for (Integer each : results) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    public boolean execute() throws SQLException {
        List<Boolean> result = this.executorEngine.execute(this.sqlType, this.preparedStatementUnits, new ExecuteCallback<Boolean>(){

            @Override
            public Boolean execute(BaseStatementUnit baseStatementUnit) throws Exception {
                return ((PreparedStatement)baseStatementUnit.getStatement()).execute();
            }
        });
        if (null == result || result.isEmpty() || null == result.get(0)) {
            return false;
        }
        return result.get(0);
    }

    @ConstructorProperties(value={"executorEngine", "sqlType", "preparedStatementUnits"})
    public PreparedStatementExecutor(ExecutorEngine executorEngine, SQLType sqlType, Collection<PreparedStatementUnit> preparedStatementUnits) {
        this.executorEngine = executorEngine;
        this.sqlType = sqlType;
        this.preparedStatementUnits = preparedStatementUnits;
    }
}

