/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.BaseStatementUnit;
import io.shardingsphere.core.executor.ExecuteCallback;
import io.shardingsphere.core.executor.event.AbstractExecutionEvent;
import io.shardingsphere.core.executor.event.AbstractSQLExecutionEvent;
import io.shardingsphere.core.executor.event.DMLExecutionEvent;
import io.shardingsphere.core.executor.event.DQLExecutionEvent;
import io.shardingsphere.core.executor.event.EventExecutionType;
import io.shardingsphere.core.executor.event.OverallExecutionEvent;
import io.shardingsphere.core.executor.threadlocal.ExecutorDataMap;
import io.shardingsphere.core.executor.threadlocal.ExecutorExceptionHandler;
import io.shardingsphere.core.util.EventBusInstance;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorEngine
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ExecutorEngine.class);
    private static final ThreadPoolExecutor SHUTDOWN_EXECUTOR = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Sharding-JDBC-ExecutorEngineCloseTimer").build());
    private final ListeningExecutorService executorService;

    public ExecutorEngine(int executorSize) {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(executorSize, executorSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Sharding-JDBC-%d").build()));
        MoreExecutors.addDelayedShutdownHook((ExecutorService)this.executorService, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    public <T> List<T> execute(SQLType sqlType, Collection<? extends BaseStatementUnit> baseStatementUnits, ExecuteCallback<T> executeCallback) throws SQLException {
        List restOutputs;
        T firstOutput;
        if (baseStatementUnits.isEmpty()) {
            return Collections.emptyList();
        }
        OverallExecutionEvent event = new OverallExecutionEvent(sqlType, baseStatementUnits.size());
        EventBusInstance.getInstance().post((Object)event);
        Iterator<? extends BaseStatementUnit> iterator = baseStatementUnits.iterator();
        BaseStatementUnit firstInput = iterator.next();
        ListenableFuture<List<T>> restFutures = this.asyncExecute(sqlType, Lists.newArrayList(iterator), executeCallback);
        try {
            firstOutput = this.syncExecute(sqlType, firstInput, executeCallback);
            restOutputs = (List)restFutures.get();
        }
        catch (Exception ex) {
            event.setException(ex);
            event.setEventExecutionType(EventExecutionType.EXECUTE_FAILURE);
            EventBusInstance.getInstance().post((Object)event);
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
        event.setEventExecutionType(EventExecutionType.EXECUTE_SUCCESS);
        EventBusInstance.getInstance().post((Object)event);
        LinkedList result = Lists.newLinkedList((Iterable)restOutputs);
        result.add(0, firstOutput);
        return result;
    }

    private <T> ListenableFuture<List<T>> asyncExecute(final SQLType sqlType, Collection<BaseStatementUnit> baseStatementUnits, final ExecuteCallback<T> executeCallback) {
        ArrayList<ListenableFuture> result = new ArrayList<ListenableFuture>(baseStatementUnits.size());
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        for (final BaseStatementUnit each : baseStatementUnits) {
            result.add(this.executorService.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return ExecutorEngine.this.executeInternal(sqlType, each, executeCallback, isExceptionThrown, dataMap);
                }
            }));
        }
        return Futures.allAsList(result);
    }

    private <T> T syncExecute(SQLType sqlType, BaseStatementUnit baseStatementUnit, ExecuteCallback<T> executeCallback) throws Exception {
        return this.executeInternal(sqlType, baseStatementUnit, executeCallback, ExecutorExceptionHandler.isExceptionThrown(), ExecutorDataMap.getDataMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeInternal(SQLType sqlType, BaseStatementUnit baseStatementUnit, ExecuteCallback<T> executeCallback, boolean isExceptionThrown, Map<String, Object> dataMap) throws Exception {
        Connection connection = baseStatementUnit.getStatement().getConnection();
        synchronized (connection) {
            T result;
            ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
            ExecutorDataMap.setDataMap(dataMap);
            LinkedList<AbstractExecutionEvent> events = new LinkedList<AbstractExecutionEvent>();
            for (List list : baseStatementUnit.getSqlExecutionUnit().getSqlUnit().getParameterSets()) {
                events.add(this.getExecutionEvent(sqlType, baseStatementUnit, list));
            }
            for (AbstractExecutionEvent abstractExecutionEvent : events) {
                EventBusInstance.getInstance().post((Object)abstractExecutionEvent);
            }
            try {
                result = executeCallback.execute(baseStatementUnit);
            }
            catch (SQLException ex) {
                for (AbstractExecutionEvent each : events) {
                    each.setEventExecutionType(EventExecutionType.EXECUTE_FAILURE);
                    each.setException(ex);
                    EventBusInstance.getInstance().post((Object)each);
                    ExecutorExceptionHandler.handleException(ex);
                }
                return null;
            }
            for (AbstractExecutionEvent abstractExecutionEvent : events) {
                abstractExecutionEvent.setEventExecutionType(EventExecutionType.EXECUTE_SUCCESS);
                EventBusInstance.getInstance().post((Object)abstractExecutionEvent);
            }
            return result;
        }
    }

    private AbstractExecutionEvent getExecutionEvent(SQLType sqlType, BaseStatementUnit baseStatementUnit, List<Object> parameters) {
        AbstractSQLExecutionEvent result = SQLType.DQL == sqlType ? new DQLExecutionEvent(baseStatementUnit.getSqlExecutionUnit().getDataSource(), baseStatementUnit.getSqlExecutionUnit().getSqlUnit(), parameters) : new DMLExecutionEvent(baseStatementUnit.getSqlExecutionUnit().getDataSource(), baseStatementUnit.getSqlExecutionUnit().getSqlUnit(), parameters);
        return result;
    }

    @Override
    public void close() {
        SHUTDOWN_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutorEngine.this.executorService.shutdown();
                    while (!ExecutorEngine.this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        ExecutorEngine.this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    log.error("ExecutorEngine can not been terminated", (Throwable)ex);
                }
            }
        });
    }
}

