/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

public class ConfigurationCache
implements ConfigurationChangeListener {
    private static final String METHOD_PREFIX = "get";
    private static final String METHOD_LATEST_CONFIG = "getLatestConfig";
    private static final ConcurrentHashMap<String, Object> CONFIG_CACHE = new ConcurrentHashMap();
    private Map<String, HashSet<ConfigurationChangeListener>> configListenersMap = new HashMap<String, HashSet<ConfigurationChangeListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigListener(String dataId, ConfigurationChangeListener ... listeners) {
        if (StringUtils.isBlank((String)dataId)) {
            return;
        }
        Class<ConfigurationCache> clazz = ConfigurationCache.class;
        synchronized (ConfigurationCache.class) {
            HashSet listenerHashSet = ConfigurationCache.getInstance().configListenersMap.computeIfAbsent(dataId, key -> new HashSet());
            if (!listenerHashSet.contains(ConfigurationCache.getInstance())) {
                ConfigurationFactory.getInstance().addConfigListener(dataId, ConfigurationCache.getInstance());
                listenerHashSet.add(ConfigurationCache.getInstance());
            }
            if (null != listeners && listeners.length > 0) {
                for (ConfigurationChangeListener listener : listeners) {
                    if (listenerHashSet.contains(listener)) continue;
                    listenerHashSet.add(listener);
                    ConfigurationFactory.getInstance().addConfigListener(dataId, listener);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ConfigurationCache getInstance() {
        return ConfigurationCacheInstance.INSTANCE;
    }

    @Override
    public void onChangeEvent(ConfigurationChangeEvent event) {
        Object oldValue = CONFIG_CACHE.get(event.getDataId());
        if (null == oldValue || !oldValue.equals(event.getNewValue())) {
            if (StringUtils.isNotBlank((String)event.getNewValue())) {
                CONFIG_CACHE.put(event.getDataId(), event.getNewValue());
            } else {
                CONFIG_CACHE.remove(event.getDataId());
            }
        }
    }

    public Configuration proxy(Configuration originalConfiguration) {
        return (Configuration)Enhancer.create(Configuration.class, (Callback)((MethodInterceptor)(proxy, method, args, methodProxy) -> {
            if (method.getName().startsWith(METHOD_PREFIX) && !method.getName().equalsIgnoreCase(METHOD_LATEST_CONFIG)) {
                String rawDataId = (String)args[0];
                Object result = CONFIG_CACHE.get(rawDataId);
                if (null == result && (result = method.invoke((Object)originalConfiguration, args)) != null) {
                    CONFIG_CACHE.put(rawDataId, result);
                }
                if (null != result && method.getReturnType().equals(String.class)) {
                    return String.valueOf(result);
                }
                return result;
            }
            return method.invoke((Object)originalConfiguration, args);
        }));
    }

    public void clear() {
        CONFIG_CACHE.clear();
    }

    private static class ConfigurationCacheInstance {
        private static final ConfigurationCache INSTANCE = new ConfigurationCache();

        private ConfigurationCacheInstance() {
        }
    }
}

