/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.runtime;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Collation;
import io.quarkus.mongodb.panache.runtime.MongoPropertyUtil;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Range;
import io.quarkus.panache.common.exception.PanacheQueryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

public class CommonPanacheQueryImpl<Entity> {
    private MongoCollection collection;
    private Bson mongoQuery;
    private Bson sort;
    private Bson projections;
    private Page page;
    private Long count;
    private Range range;
    private Collation collation;

    public CommonPanacheQueryImpl(MongoCollection<? extends Entity> collection, Bson mongoQuery, Bson sort) {
        this.collection = collection;
        this.mongoQuery = mongoQuery;
        this.sort = sort;
    }

    private CommonPanacheQueryImpl(CommonPanacheQueryImpl<?> previousQuery, Bson projections, Class<?> documentClass) {
        this.collection = previousQuery.collection.withDocumentClass(documentClass);
        this.mongoQuery = previousQuery.mongoQuery;
        this.sort = previousQuery.sort;
        this.projections = projections;
        this.page = previousQuery.page;
        this.count = previousQuery.count;
        this.range = previousQuery.range;
        this.collation = previousQuery.collation;
    }

    public <T> CommonPanacheQueryImpl<T> project(Class<T> type) {
        Set<String> fieldNames = MongoPropertyUtil.collectFields(type);
        Document projections = new Document();
        for (String fieldName : fieldNames) {
            projections.append(fieldName, (Object)1);
        }
        return new CommonPanacheQueryImpl<Entity>(this, (Bson)projections, type);
    }

    public <T extends Entity> CommonPanacheQueryImpl<T> page(Page page) {
        this.page = page;
        this.range = null;
        return this;
    }

    public <T extends Entity> CommonPanacheQueryImpl<T> page(int pageIndex, int pageSize) {
        return this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    public <T extends Entity> CommonPanacheQueryImpl<T> nextPage() {
        this.checkPagination();
        return this.page(this.page.next());
    }

    public <T extends Entity> CommonPanacheQueryImpl<T> previousPage() {
        this.checkPagination();
        return this.page(this.page.previous());
    }

    public <T extends Entity> CommonPanacheQueryImpl<T> firstPage() {
        this.checkPagination();
        return this.page(this.page.first());
    }

    public <T extends Entity> CommonPanacheQueryImpl<T> lastPage() {
        this.checkPagination();
        return this.page(this.page.index(this.pageCount() - 1));
    }

    public boolean hasNextPage() {
        this.checkPagination();
        return this.page.index < this.pageCount() - 1;
    }

    public boolean hasPreviousPage() {
        this.checkPagination();
        return this.page.index > 0;
    }

    public int pageCount() {
        this.checkPagination();
        long count = this.count();
        if (count == 0L) {
            return 1;
        }
        return (int)Math.ceil((double)count / (double)this.page.size);
    }

    public Page page() {
        this.checkPagination();
        return this.page;
    }

    private void checkPagination() {
        if (this.page == null) {
            throw new UnsupportedOperationException("Cannot call a page related method, call page(Page) or page(int, int) to initiate pagination first");
        }
        if (this.range != null) {
            throw new UnsupportedOperationException("Cannot call a page related method in a ranged query, call page(Page) or page(int, int) to initiate pagination first");
        }
    }

    public <T extends Entity> CommonPanacheQueryImpl<T> range(int startIndex, int lastIndex) {
        this.range = Range.of((int)startIndex, (int)lastIndex);
        this.page = null;
        return this;
    }

    public <T extends Entity> CommonPanacheQueryImpl<T> withCollation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public long count() {
        if (this.count == null) {
            this.count = this.collection.countDocuments(this.mongoQuery);
        }
        return this.count;
    }

    public <T extends Entity> List<T> list() {
        return this.list(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Entity> List<T> list(Integer limit) {
        FindIterable find;
        ArrayList<Object> list = new ArrayList<Object>();
        FindIterable findIterable = find = this.mongoQuery == null ? this.collection.find() : this.collection.find(this.mongoQuery);
        if (this.projections != null) {
            find.projection(this.projections);
        }
        if (this.collation != null) {
            find.collation(this.collation);
        }
        this.manageOffsets(find, limit);
        try (MongoCursor cursor = find.sort(this.sort).iterator();){
            while (cursor.hasNext()) {
                Object entity = cursor.next();
                list.add(entity);
            }
        }
        return list;
    }

    public <T extends Entity> Stream<T> stream() {
        return this.list().stream();
    }

    public <T extends Entity> T firstResult() {
        List<T> list = this.list(1);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    public <T extends Entity> Optional<T> firstResultOptional() {
        return Optional.ofNullable(this.firstResult());
    }

    public <T extends Entity> T singleResult() {
        List<T> list = this.list(2);
        if (list.size() != 1) {
            throw new PanacheQueryException("There should be only one result");
        }
        return list.get(0);
    }

    public <T extends Entity> Optional<T> singleResultOptional() {
        List<T> list = this.list(2);
        if (list.size() > 1) {
            throw new PanacheQueryException("There should be no more than one result");
        }
        return list.isEmpty() ? Optional.empty() : Optional.of(list.get(0));
    }

    private void manageOffsets(FindIterable find, Integer limit) {
        if (this.range != null) {
            find.skip(this.range.getStartIndex());
            if (limit == null) {
                find.limit(this.range.getLastIndex() - this.range.getStartIndex() + 1);
            }
        } else if (this.page != null) {
            find.skip(this.page.index * this.page.size);
            if (limit == null) {
                find.limit(this.page.size);
            }
        }
        if (limit != null) {
            find.limit(limit.intValue());
        }
    }
}

