/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.clients;

import io.pinecone.clients.AsyncIndex;
import io.pinecone.clients.Index;
import io.pinecone.clients.Inference;
import io.pinecone.configs.PineconeConfig;
import io.pinecone.configs.PineconeConnection;
import io.pinecone.configs.ProxyConfig;
import io.pinecone.exceptions.FailedRequestInfo;
import io.pinecone.exceptions.HttpErrorMapper;
import io.pinecone.exceptions.PineconeConfigurationException;
import io.pinecone.exceptions.PineconeException;
import io.pinecone.exceptions.PineconeValidationException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.OkHttpClient;
import org.openapitools.db_control.client.ApiClient;
import org.openapitools.db_control.client.ApiException;
import org.openapitools.db_control.client.api.ManageIndexesApi;
import org.openapitools.db_control.client.model.CollectionList;
import org.openapitools.db_control.client.model.CollectionModel;
import org.openapitools.db_control.client.model.ConfigureIndexRequest;
import org.openapitools.db_control.client.model.ConfigureIndexRequestSpec;
import org.openapitools.db_control.client.model.ConfigureIndexRequestSpecPod;
import org.openapitools.db_control.client.model.CreateCollectionRequest;
import org.openapitools.db_control.client.model.CreateIndexRequest;
import org.openapitools.db_control.client.model.DeletionProtection;
import org.openapitools.db_control.client.model.IndexList;
import org.openapitools.db_control.client.model.IndexModel;
import org.openapitools.db_control.client.model.IndexSpec;
import org.openapitools.db_control.client.model.PodSpec;
import org.openapitools.db_control.client.model.PodSpecMetadataConfig;
import org.openapitools.db_control.client.model.ServerlessSpec;

public class Pinecone {
    private static final ConcurrentHashMap<String, PineconeConnection> connectionsMap = new ConcurrentHashMap();
    private final ManageIndexesApi manageIndexesApi;
    private final PineconeConfig config;

    Pinecone(PineconeConfig config, ManageIndexesApi manageIndexesApi) {
        this.config = config;
        this.manageIndexesApi = manageIndexesApi;
    }

    PineconeConfig getConfig() {
        return this.config;
    }

    public IndexModel createServerlessIndex(String indexName, String metric, int dimension, String cloud, String region, DeletionProtection deletionProtection, Map<String, String> tags) throws PineconeException {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("Index name cannot be null or empty");
        }
        if (metric == null || metric.isEmpty()) {
            metric = "cosine";
        }
        try {
            CreateIndexRequest.MetricEnum.fromValue(metric.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new PineconeValidationException("Metric cannot be null or empty. Must be one of " + Arrays.toString((Object[])CreateIndexRequest.MetricEnum.values()));
        }
        if (dimension < 1) {
            throw new PineconeValidationException("Dimension must be greater than 0. See limits for more info: https://docs.pinecone.io/reference/limits");
        }
        if (cloud == null || cloud.isEmpty()) {
            throw new PineconeValidationException("Cloud cannot be null or empty. Must be one of " + Arrays.toString((Object[])ServerlessSpec.CloudEnum.values()));
        }
        try {
            ServerlessSpec.CloudEnum.fromValue(cloud.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new PineconeValidationException("Cloud cannot be null or empty. Must be one of " + Arrays.toString((Object[])ServerlessSpec.CloudEnum.values()));
        }
        if (region == null || region.isEmpty()) {
            throw new PineconeValidationException("Region cannot be null or empty");
        }
        CreateIndexRequest.MetricEnum userMetric = CreateIndexRequest.MetricEnum.fromValue(metric.toLowerCase());
        ServerlessSpec.CloudEnum cloudProvider = ServerlessSpec.CloudEnum.fromValue(cloud.toLowerCase());
        ServerlessSpec serverlessSpec = new ServerlessSpec().cloud(cloudProvider).region(region);
        IndexSpec createServerlessIndexRequestSpec = new IndexSpec().serverless(serverlessSpec);
        IndexModel indexModel = null;
        try {
            CreateIndexRequest createIndexRequest = new CreateIndexRequest().name(indexName).metric(userMetric).dimension(dimension).spec(createServerlessIndexRequestSpec).deletionProtection(deletionProtection);
            if (tags != null && !tags.isEmpty()) {
                createIndexRequest.tags(tags);
            }
            indexModel = this.manageIndexesApi.createIndex(createIndexRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public IndexModel createSparseServelessIndex(String indexName, String cloud, String region, DeletionProtection deletionProtection, Map<String, String> tags, String vectorType) throws PineconeException {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("Index name cannot be null or empty");
        }
        if (cloud == null || cloud.isEmpty()) {
            throw new PineconeValidationException("Cloud cannot be null or empty. Must be one of " + Arrays.toString((Object[])ServerlessSpec.CloudEnum.values()));
        }
        try {
            ServerlessSpec.CloudEnum.fromValue(cloud.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new PineconeValidationException("Cloud cannot be null or empty. Must be one of " + Arrays.toString((Object[])ServerlessSpec.CloudEnum.values()));
        }
        if (region == null || region.isEmpty()) {
            throw new PineconeValidationException("Region cannot be null or empty");
        }
        if (!vectorType.equalsIgnoreCase("sparse") && !vectorType.equalsIgnoreCase("dense")) {
            throw new PineconeValidationException("vectorType must be sparse or dense");
        }
        ServerlessSpec.CloudEnum cloudProvider = ServerlessSpec.CloudEnum.fromValue(cloud.toLowerCase());
        ServerlessSpec serverlessSpec = new ServerlessSpec().cloud(cloudProvider).region(region);
        IndexSpec createServerlessIndexRequestSpec = new IndexSpec().serverless(serverlessSpec);
        IndexModel indexModel = null;
        try {
            CreateIndexRequest createIndexRequest = new CreateIndexRequest().name(indexName).metric(CreateIndexRequest.MetricEnum.DOTPRODUCT).spec(createServerlessIndexRequestSpec).deletionProtection(deletionProtection).vectorType(vectorType);
            if (tags != null && !tags.isEmpty()) {
                createIndexRequest.tags(tags);
            }
            indexModel = this.manageIndexesApi.createIndex(createIndexRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, null, null, null, null, null, DeletionProtection.DISABLED, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, DeletionProtection deletionProtection) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, null, null, null, null, null, deletionProtection, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, String metric) {
        return this.createPodsIndex(indexName, dimension, environment, podType, metric, null, null, null, null, null, DeletionProtection.DISABLED, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, String metric, PodSpecMetadataConfig metadataConfig) {
        return this.createPodsIndex(indexName, dimension, environment, podType, metric, null, null, null, metadataConfig, null, DeletionProtection.DISABLED, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, String metric, String sourceCollection) {
        return this.createPodsIndex(indexName, dimension, environment, podType, metric, null, null, null, null, sourceCollection, DeletionProtection.DISABLED, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, Integer pods) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, null, null, pods, null, null, DeletionProtection.DISABLED, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, Integer pods, PodSpecMetadataConfig metadataConfig) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, null, null, pods, metadataConfig, null, DeletionProtection.DISABLED, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, Integer replicas, Integer shards) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, replicas, shards, null, null, null, DeletionProtection.DISABLED, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, Integer replicas, Integer shards, PodSpecMetadataConfig metadataConfig) {
        return this.createPodsIndex(indexName, dimension, environment, podType, null, replicas, shards, null, metadataConfig, null, DeletionProtection.DISABLED, null);
    }

    public IndexModel createPodsIndex(String indexName, Integer dimension, String environment, String podType, String metric, Integer replicas, Integer shards, Integer pods, PodSpecMetadataConfig metadataConfig, String sourceCollection, DeletionProtection deletionProtection, Map<String, String> tags) throws PineconeException {
        Pinecone.validatePodIndexParams(indexName, dimension, environment, podType, metric, replicas, shards, pods);
        PodSpec podSpec = new PodSpec().environment(environment).podType(podType).replicas(replicas).shards(shards).pods(pods).metadataConfig(metadataConfig).sourceCollection(sourceCollection);
        IndexSpec createIndexRequestSpec = new IndexSpec().pod(podSpec);
        CreateIndexRequest createIndexRequest = new CreateIndexRequest().name(indexName).dimension(dimension).metric(metric != null ? CreateIndexRequest.MetricEnum.fromValue(metric) : CreateIndexRequest.MetricEnum.COSINE).spec(createIndexRequestSpec).deletionProtection(deletionProtection);
        if (tags != null && !tags.isEmpty()) {
            createIndexRequest.tags(tags);
        }
        IndexModel indexModel = null;
        try {
            indexModel = this.manageIndexesApi.createIndex(createIndexRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public static void validatePodIndexParams(String indexName, Integer dimension, String environment, String podType, String metric, Integer replicas, Integer shards, Integer pods) {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("indexName cannot be null or empty");
        }
        if (dimension == null) {
            throw new PineconeValidationException("Dimension cannot be null");
        }
        if (dimension < 1) {
            throw new PineconeValidationException("Dimension must be greater than 0. See limits for more info: https://docs.pinecone.io/reference/limits");
        }
        if (environment == null || environment.isEmpty()) {
            throw new PineconeValidationException("Environment cannot be null or empty");
        }
        if (podType == null || podType.isEmpty()) {
            throw new PineconeValidationException("podType cannot be null or empty");
        }
        if (metric != null && metric.isEmpty()) {
            throw new PineconeValidationException("Metric cannot be null or empty. Must be one of " + Arrays.toString((Object[])IndexModel.MetricEnum.values()));
        }
        if (replicas != null && replicas < 1) {
            throw new PineconeValidationException("Number of replicas must be >= 1");
        }
        if (shards != null && shards < 1) {
            throw new PineconeValidationException("Number of shards must be >= 1");
        }
        if (pods != null && pods < 1) {
            throw new PineconeValidationException("Number of pods must be >= 1");
        }
        if (replicas != null && shards != null && pods != null && replicas * shards != pods) {
            throw new PineconeValidationException("Number of pods does not equal number of shards times number of replicas");
        }
    }

    public IndexModel describeIndex(String indexName) throws PineconeException {
        IndexModel indexModel = null;
        try {
            indexModel = this.manageIndexesApi.describeIndex(indexName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public IndexModel configurePodsIndex(String indexName, String podType, Integer replicas, DeletionProtection deletionProtection, Map<String, String> tags) throws PineconeException {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("indexName cannot be null or empty");
        }
        if (replicas != null && replicas < 1) {
            throw new PineconeValidationException("Number of replicas must be >= 1");
        }
        ConfigureIndexRequest configureIndexRequest = new ConfigureIndexRequest().spec(new ConfigureIndexRequestSpec().pod(new ConfigureIndexRequestSpecPod().replicas(replicas).podType(podType))).deletionProtection(deletionProtection);
        if (tags != null && !tags.isEmpty()) {
            configureIndexRequest.tags(tags);
        }
        IndexModel indexModel = null;
        try {
            indexModel = this.manageIndexesApi.configureIndex(indexName, configureIndexRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public IndexModel configurePodsIndex(String indexName, Integer replicas, DeletionProtection deletionProtection) throws PineconeException {
        return this.configurePodsIndex(indexName, null, replicas, deletionProtection, null);
    }

    public IndexModel configurePodsIndex(String indexName, String podType) throws PineconeException {
        DeletionProtection deletionProtection = this.describeIndex(indexName).getDeletionProtection();
        return this.configurePodsIndex(indexName, podType, null, deletionProtection, null);
    }

    public IndexModel configurePodsIndex(String indexName, DeletionProtection deletionProtection) throws PineconeException {
        return this.configurePodsIndex(indexName, null, null, deletionProtection, null);
    }

    public IndexModel configureServerlessIndex(String indexName, DeletionProtection deletionProtection, Map<String, String> tags) throws PineconeException {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("indexName cannot be null or empty");
        }
        ConfigureIndexRequest configureIndexRequest = new ConfigureIndexRequest().deletionProtection(deletionProtection);
        if (tags != null && !tags.isEmpty()) {
            configureIndexRequest.tags(tags);
        }
        IndexModel indexModel = null;
        try {
            indexModel = this.manageIndexesApi.configureIndex(indexName, configureIndexRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public IndexList listIndexes() throws PineconeException {
        IndexList indexList = null;
        try {
            indexList = this.manageIndexesApi.listIndexes();
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexList;
    }

    public void deleteIndex(String indexName) throws PineconeException {
        try {
            this.manageIndexesApi.deleteIndex(indexName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
    }

    public CollectionModel createCollection(String collectionName, String sourceIndex) throws PineconeException {
        if (collectionName == null || collectionName.isEmpty()) {
            throw new PineconeValidationException("collectionName cannot be null or empty");
        }
        if (sourceIndex == null || sourceIndex.isEmpty()) {
            throw new PineconeValidationException("sourceIndex cannot be null or empty");
        }
        CreateCollectionRequest createCollectionRequest = new CreateCollectionRequest().name(collectionName).source(sourceIndex);
        CollectionModel collection = null;
        try {
            collection = this.manageIndexesApi.createCollection(createCollectionRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return collection;
    }

    public CollectionModel describeCollection(String collectionName) throws PineconeException {
        CollectionModel collection = null;
        try {
            collection = this.manageIndexesApi.describeCollection(collectionName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return collection;
    }

    public CollectionList listCollections() throws PineconeException {
        CollectionList collections = null;
        try {
            collections = this.manageIndexesApi.listCollections();
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return collections;
    }

    public void deleteCollection(String collectionName) throws PineconeException {
        try {
            this.manageIndexesApi.deleteCollection(collectionName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
    }

    public Index getIndexConnection(String indexName) throws PineconeValidationException {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("Index name cannot be null or empty");
        }
        PineconeConnection connection = this.getConnection(indexName);
        return new Index(connection, indexName);
    }

    public AsyncIndex getAsyncIndexConnection(String indexName) throws PineconeValidationException {
        if (indexName == null || indexName.isEmpty()) {
            throw new PineconeValidationException("Index name cannot be null or empty");
        }
        PineconeConnection connection = this.getConnection(indexName);
        return new AsyncIndex(this.config, connection, indexName);
    }

    public Inference getInferenceClient() {
        return new Inference(this.config);
    }

    PineconeConnection getConnection(String indexName) {
        PineconeConfig perConnectionConfig = new PineconeConfig(this.config.getApiKey(), this.config.getSourceTag());
        perConnectionConfig.setHost(this.getIndexHost(indexName));
        return connectionsMap.computeIfAbsent(indexName, key -> new PineconeConnection(perConnectionConfig));
    }

    ConcurrentHashMap<String, PineconeConnection> getConnectionsMap() {
        return connectionsMap;
    }

    String getIndexHost(String indexName) {
        return this.describeIndex(indexName).getHost();
    }

    static void closeConnection(String indexName) {
        connectionsMap.remove(indexName);
    }

    private void handleApiException(ApiException apiException) throws PineconeException {
        int statusCode = apiException.getCode();
        String responseBody = apiException.getResponseBody();
        FailedRequestInfo failedRequestInfo = new FailedRequestInfo(statusCode, responseBody);
        HttpErrorMapper.mapHttpStatusError(failedRequestInfo, apiException);
    }

    static OkHttpClient buildOkHttpClient(ProxyConfig proxyConfig) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (proxyConfig != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.getHost(), proxyConfig.getPort()));
            builder.proxy(proxy);
        }
        return builder.build();
    }

    public static class Builder {
        private final String apiKey;
        private String host;
        private String sourceTag;
        private ProxyConfig proxyConfig;
        private OkHttpClient customOkHttpClient;
        private boolean enableTls = true;

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder withSourceTag(String sourceTag) {
            this.sourceTag = sourceTag;
            return this;
        }

        public Builder withOkHttpClient(OkHttpClient okHttpClient) {
            this.customOkHttpClient = okHttpClient;
            return this;
        }

        public Builder withProxy(String proxyHost, int proxyPort) {
            this.proxyConfig = new ProxyConfig(proxyHost, proxyPort);
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withTlsEnabled(boolean enableTls) {
            this.enableTls = enableTls;
            return this;
        }

        public Pinecone build() {
            ApiClient apiClient;
            PineconeConfig config = new PineconeConfig(this.apiKey, this.sourceTag, this.proxyConfig, this.customOkHttpClient);
            config.setTLSEnabled(this.enableTls);
            config.validate();
            if (this.proxyConfig != null && this.customOkHttpClient != null) {
                throw new PineconeConfigurationException("Invalid configuration: Both Custom OkHttpClient and Proxy are set. Please configure only one of these options.");
            }
            if (this.customOkHttpClient != null) {
                apiClient = new ApiClient(this.customOkHttpClient);
            } else {
                apiClient = new ApiClient(Pinecone.buildOkHttpClient(this.proxyConfig));
                if (this.host != null && !this.host.isEmpty()) {
                    config.setHost(this.host);
                    apiClient.setBasePath(this.host);
                }
            }
            apiClient.setApiKey(config.getApiKey());
            apiClient.setUserAgent(config.getUserAgent());
            apiClient.addDefaultHeader("X-Pinecone-Api-Version", "2025-01");
            if (Boolean.parseBoolean(System.getenv("PINECONE_DEBUG"))) {
                apiClient.setDebugging(true);
            }
            ManageIndexesApi manageIndexesApi = new ManageIndexesApi();
            manageIndexesApi.setApiClient(apiClient);
            return new Pinecone(config, manageIndexesApi);
        }
    }
}

