/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class JaegerGrpcSpanExporterBuilder
extends ConfigBuilder<JaegerGrpcSpanExporterBuilder> {
    private static final String KEY_SERVICE_NAME = "otel.exporter.jaeger.service.name";
    private static final String KEY_ENDPOINT = "otel.exporter.jaeger.endpoint";
    private static final String DEFAULT_ENDPOINT = "localhost:14250";
    private static final String DEFAULT_SERVICE_NAME = "unknown";
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private String serviceName = "unknown";
    private String endpoint = "localhost:14250";
    private ManagedChannel channel;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);

    public JaegerGrpcSpanExporterBuilder setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public JaegerGrpcSpanExporterBuilder setChannel(ManagedChannel channel) {
        this.channel = channel;
        return this;
    }

    public JaegerGrpcSpanExporterBuilder setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public JaegerGrpcSpanExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public JaegerGrpcSpanExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Deprecated
    public JaegerGrpcSpanExporterBuilder setDeadlineMs(long deadlineMs) {
        return this.setTimeout(Duration.ofMillis(deadlineMs));
    }

    protected JaegerGrpcSpanExporterBuilder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
        String stringValue = JaegerGrpcSpanExporterBuilder.getStringProperty((String)KEY_SERVICE_NAME, (Map)(configMap = namingConvention.normalize(configMap)));
        if (stringValue != null) {
            this.setServiceName(stringValue);
        }
        if ((stringValue = JaegerGrpcSpanExporterBuilder.getStringProperty((String)KEY_ENDPOINT, (Map)configMap)) != null) {
            this.setEndpoint(stringValue);
        }
        return this;
    }

    public JaegerGrpcSpanExporter build() {
        if (this.channel == null) {
            this.channel = ManagedChannelBuilder.forTarget((String)this.endpoint).usePlaintext().build();
        }
        return new JaegerGrpcSpanExporter(this.serviceName, this.channel, this.timeoutNanos);
    }

    JaegerGrpcSpanExporterBuilder() {
    }
}

