/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

class McpClientFeatures {
    McpClientFeatures() {
    }

    public record Sync(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers, List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers, List<Consumer<List<McpSchema.ResourceContents>>> resourcesUpdateConsumers, List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers, List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers, List<Consumer<McpSchema.ProgressNotification>> progressConsumers, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler, Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler, boolean enableCallToolSchemaCaching) {
        public Sync(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers, List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers, List<Consumer<List<McpSchema.ResourceContents>>> resourcesUpdateConsumers, List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers, List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers, List<Consumer<McpSchema.ProgressNotification>> progressConsumers, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler, Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler, boolean enableCallToolSchemaCaching) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            this.clientCapabilities = clientCapabilities != null ? clientCapabilities : new McpSchema.ClientCapabilities(null, !Utils.isEmpty(roots) ? new McpSchema.ClientCapabilities.RootCapabilities(false) : null, samplingHandler != null ? new McpSchema.ClientCapabilities.Sampling() : null, elicitationHandler != null ? new McpSchema.ClientCapabilities.Elicitation() : null);
            this.roots = roots != null ? new HashMap<String, McpSchema.Root>(roots) : new HashMap();
            this.toolsChangeConsumers = toolsChangeConsumers != null ? toolsChangeConsumers : List.of();
            this.resourcesChangeConsumers = resourcesChangeConsumers != null ? resourcesChangeConsumers : List.of();
            this.resourcesUpdateConsumers = resourcesUpdateConsumers != null ? resourcesUpdateConsumers : List.of();
            this.promptsChangeConsumers = promptsChangeConsumers != null ? promptsChangeConsumers : List.of();
            this.loggingConsumers = loggingConsumers != null ? loggingConsumers : List.of();
            this.progressConsumers = progressConsumers != null ? progressConsumers : List.of();
            this.samplingHandler = samplingHandler;
            this.elicitationHandler = elicitationHandler;
            this.enableCallToolSchemaCaching = enableCallToolSchemaCaching;
        }

        public Sync(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers, List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers, List<Consumer<List<McpSchema.ResourceContents>>> resourcesUpdateConsumers, List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers, List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler, Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler) {
            this(clientInfo, clientCapabilities, roots, toolsChangeConsumers, resourcesChangeConsumers, resourcesUpdateConsumers, promptsChangeConsumers, loggingConsumers, List.of(), samplingHandler, elicitationHandler, false);
        }
    }

    record Async(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers, List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers, List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumers, List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers, List<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumers, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler, Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler, boolean enableCallToolSchemaCaching) {
        public Async(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers, List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers, List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumers, List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers, List<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumers, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler, Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler, boolean enableCallToolSchemaCaching) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            this.clientCapabilities = clientCapabilities != null ? clientCapabilities : new McpSchema.ClientCapabilities(null, !Utils.isEmpty(roots) ? new McpSchema.ClientCapabilities.RootCapabilities(false) : null, samplingHandler != null ? new McpSchema.ClientCapabilities.Sampling() : null, elicitationHandler != null ? new McpSchema.ClientCapabilities.Elicitation() : null);
            this.roots = roots != null ? new ConcurrentHashMap<String, McpSchema.Root>(roots) : new ConcurrentHashMap();
            this.toolsChangeConsumers = toolsChangeConsumers != null ? toolsChangeConsumers : List.of();
            this.resourcesChangeConsumers = resourcesChangeConsumers != null ? resourcesChangeConsumers : List.of();
            this.resourcesUpdateConsumers = resourcesUpdateConsumers != null ? resourcesUpdateConsumers : List.of();
            this.promptsChangeConsumers = promptsChangeConsumers != null ? promptsChangeConsumers : List.of();
            this.loggingConsumers = loggingConsumers != null ? loggingConsumers : List.of();
            this.progressConsumers = progressConsumers != null ? progressConsumers : List.of();
            this.samplingHandler = samplingHandler;
            this.elicitationHandler = elicitationHandler;
            this.enableCallToolSchemaCaching = enableCallToolSchemaCaching;
        }

        public Async(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers, List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers, List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumers, List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler, Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler) {
            this(clientInfo, clientCapabilities, roots, toolsChangeConsumers, resourcesChangeConsumers, resourcesUpdateConsumers, promptsChangeConsumers, loggingConsumers, List.of(), samplingHandler, elicitationHandler, false);
        }

        public static Async fromSync(Sync syncSpec) {
            ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers = new ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Tool>> consumer : syncSpec.toolsChangeConsumers()) {
                toolsChangeConsumers.add(t -> Mono.fromRunnable(() -> consumer.accept(t)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers = new ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Resource>> consumer : syncSpec.resourcesChangeConsumers()) {
                resourcesChangeConsumers.add(r -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.Resource>)r)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.ResourceContents>, Mono<Void>>> arrayList = new ArrayList<Function<List<McpSchema.ResourceContents>, Mono<Void>>>();
            for (Consumer<List<McpSchema.ResourceContents>> consumer : syncSpec.resourcesUpdateConsumers()) {
                arrayList.add(r -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.ResourceContents>)r)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>> arrayList2 = new ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Prompt>> consumer : syncSpec.promptsChangeConsumers()) {
                arrayList2.add(p -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.Prompt>)p)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> arrayList3 = new ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>>();
            for (Consumer<McpSchema.LoggingMessageNotification> consumer : syncSpec.loggingConsumers()) {
                arrayList3.add(l -> Mono.fromRunnable(() -> consumer.accept((McpSchema.LoggingMessageNotification)l)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<McpSchema.ProgressNotification, Mono<Void>>> arrayList4 = new ArrayList<Function<McpSchema.ProgressNotification, Mono<Void>>>();
            for (Consumer<McpSchema.ProgressNotification> consumer : syncSpec.progressConsumers()) {
                arrayList4.add(l -> Mono.fromRunnable(() -> consumer.accept(l)).subscribeOn(Schedulers.boundedElastic()));
            }
            Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> function = r -> Mono.fromCallable(() -> syncSpec.samplingHandler().apply((McpSchema.CreateMessageRequest)r)).subscribeOn(Schedulers.boundedElastic());
            Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> function2 = r -> Mono.fromCallable(() -> syncSpec.elicitationHandler().apply((McpSchema.ElicitRequest)r)).subscribeOn(Schedulers.boundedElastic());
            return new Async(syncSpec.clientInfo(), syncSpec.clientCapabilities(), syncSpec.roots(), toolsChangeConsumers, resourcesChangeConsumers, arrayList, arrayList2, arrayList3, arrayList4, function, function2, syncSpec.enableCallToolSchemaCaching);
        }
    }
}

