/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response.basic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.milvus.exception.ParamException;
import io.milvus.grpc.FieldData;
import io.milvus.response.FieldDataWrapper;
import io.milvus.response.QueryResultsWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RowRecordWrapper {
    private ConcurrentHashMap<String, FieldDataWrapper> outputFieldsData = new ConcurrentHashMap();
    private List<String> dynamicFieldNames = null;

    public abstract List<QueryResultsWrapper.RowRecord> getRowRecords();

    protected FieldDataWrapper getFieldWrapperInternal(FieldData field) {
        if (this.outputFieldsData.containsKey(field.getFieldName())) {
            return this.outputFieldsData.get(field.getFieldName());
        }
        FieldDataWrapper wrapper = new FieldDataWrapper(field);
        this.outputFieldsData.put(field.getFieldName(), wrapper);
        return wrapper;
    }

    public FieldDataWrapper getDynamicWrapper() throws ParamException {
        List<FieldData> fields = this.getFieldDataList();
        for (FieldData field : fields) {
            if (!field.getIsDynamic()) continue;
            return this.getFieldWrapperInternal(field);
        }
        throw new ParamException("The dynamic field doesn't exist");
    }

    protected QueryResultsWrapper.RowRecord buildRowRecord(QueryResultsWrapper.RowRecord record, long index) {
        List<String> dynamicFields = this.getDynamicFieldNames();
        List<FieldData> fieldsData = this.getFieldDataList();
        for (FieldData field : fieldsData) {
            FieldDataWrapper wrapper = this.getFieldWrapperInternal(field);
            if (index < 0L || index >= wrapper.getRowCount()) {
                throw new ParamException("Index out of range");
            }
            Object value = wrapper.valueByIdx((int)index);
            if (wrapper.isJsonField()) {
                JsonElement jsonValue = FieldDataWrapper.ParseJSONObject(value);
                if (!field.getIsDynamic()) {
                    record.put(field.getFieldName(), jsonValue);
                    continue;
                }
                if (!(jsonValue instanceof JsonObject)) {
                    throw new ParamException("The content of dynamic field is not a JSON dict");
                }
                JsonObject jsonDict = (JsonObject)jsonValue;
                for (String key : jsonDict.keySet()) {
                    if (!dynamicFields.isEmpty() && !dynamicFields.contains(key)) continue;
                    record.put(key, FieldDataWrapper.ValueOfJSONElement(jsonDict.get(key)));
                }
                continue;
            }
            record.put(field.getFieldName(), value);
        }
        return record;
    }

    private List<String> getDynamicFieldNames() {
        if (this.dynamicFieldNames != null) {
            return this.dynamicFieldNames;
        }
        this.dynamicFieldNames = new ArrayList<String>();
        List<FieldData> fieldsData = this.getFieldDataList();
        String dynamicFieldName = null;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldData field : fieldsData) {
            if (!fieldNames.contains(field.getFieldName())) {
                fieldNames.add(field.getFieldName());
            }
            if (!field.getIsDynamic()) continue;
            dynamicFieldName = field.getFieldName();
        }
        List<String> outputNames = this.getOutputFields();
        for (String name : outputNames) {
            if (name.equals(dynamicFieldName)) {
                this.dynamicFieldNames.clear();
                break;
            }
            if (fieldNames.contains(name)) continue;
            this.dynamicFieldNames.add(name);
        }
        return this.dynamicFieldNames;
    }

    protected abstract List<FieldData> getFieldDataList();

    protected abstract List<String> getOutputFields();
}

