/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.resourcegroup;

import io.milvus.common.resourcegroup.ResourceGroupConfig;
import io.milvus.grpc.UpdateResourceGroupsRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class UpdateResourceGroupsParam {
    private final Map<String, ResourceGroupConfig> resourceGroups;

    private UpdateResourceGroupsParam(Builder builder) {
        if (null == builder.resourceGroups || builder.resourceGroups.isEmpty()) {
            throw new IllegalArgumentException("resourceGroups cannot be empty");
        }
        this.resourceGroups = builder.resourceGroups;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public UpdateResourceGroupsRequest toGRPC() {
        UpdateResourceGroupsRequest.Builder builder = UpdateResourceGroupsRequest.newBuilder();
        this.resourceGroups.forEach((k, v) -> builder.putResourceGroups((String)k, v.toGRPC()));
        return builder.build();
    }

    public String toString() {
        return String.format("UpdateResourceGroupsRequest{resourceGroupNames:%s}", this.resourceGroups.keySet().stream().collect(Collectors.joining(",")));
    }

    public Map<String, ResourceGroupConfig> getResourceGroups() {
        return this.resourceGroups;
    }

    public static final class Builder {
        private Map<String, ResourceGroupConfig> resourceGroups;

        private Builder() {
        }

        public Builder putResourceGroup(@NonNull String resourceGroupName, @NonNull ResourceGroupConfig resourceGroup) {
            if (resourceGroupName == null) {
                throw new NullPointerException("resourceGroupName is marked non-null but is null");
            }
            if (resourceGroup == null) {
                throw new NullPointerException("resourceGroup is marked non-null but is null");
            }
            if (null == this.resourceGroups) {
                this.resourceGroups = new HashMap<String, ResourceGroupConfig>();
            }
            this.resourceGroups.put(resourceGroupName, resourceGroup);
            return this;
        }

        public UpdateResourceGroupsParam build() {
            return new UpdateResourceGroupsParam(this);
        }
    }
}

