/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.shaded.org.reactorstreams.Processor;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.UnicastProcessor;

public class LogbackMetricsSuppressingUnicastProcessor
implements Processor<String, String> {
    private final UnicastProcessor<String> processor;

    public LogbackMetricsSuppressingUnicastProcessor(UnicastProcessor<String> processor) {
        this.processor = processor;
    }

    @Override
    public void subscribe(Subscriber<? super String> s) {
        ((Flux)this.processor).subscribe(s);
    }

    @Override
    public void onSubscribe(Subscription s) {
        this.processor.onSubscribe(s);
    }

    @Override
    public void onNext(String s) {
        LogbackMetrics.ignoreMetrics(() -> this.processor.onNext(s));
    }

    @Override
    public void onError(Throwable t) {
        LogbackMetrics.ignoreMetrics(() -> this.processor.onError(t));
    }

    @Override
    public void onComplete() {
        LogbackMetrics.ignoreMetrics(this.processor::onComplete);
    }

    public int size() {
        return this.processor.size();
    }

    public int getBufferSize() {
        return this.processor.getBufferSize();
    }
}

