/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import io.micrometer.shaded.reactor.netty.tcp.TcpClientRunOn;
import io.micrometer.shaded.reactor.netty.tcp.TcpResources;
import java.util.Objects;

final class TcpClientConnect
extends TcpClient {
    static final TcpClientConnect INSTANCE = new TcpClientConnect(ConnectionProvider.newConnection());
    final ConnectionProvider provider;

    TcpClientConnect(ConnectionProvider provider) {
        this.provider = Objects.requireNonNull(provider, "connectionProvider");
    }

    @Override
    public Mono<? extends Connection> connect(Bootstrap b) {
        if (b.config().group() == null) {
            TcpClientRunOn.configure(b, LoopResources.DEFAULT_NATIVE, TcpResources.get());
        }
        return this.provider.acquire(b);
    }
}

