/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

final class UnsafeSupport
extends Enum<UnsafeSupport> {
    static final Logger logger;
    private static final Unsafe UNSAFE;
    private static final /* synthetic */ UnsafeSupport[] $VALUES;

    public static UnsafeSupport[] values() {
        return (UnsafeSupport[])$VALUES.clone();
    }

    public static UnsafeSupport valueOf(String name) {
        return Enum.valueOf(UnsafeSupport.class, name);
    }

    static Unsafe getUnsafe() {
        return UNSAFE;
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static {
        Unsafe finalUnsafe;
        Unsafe unsafe;
        Object maybeUnsafe;
        $VALUES = new UnsafeSupport[0];
        logger = Loggers.getLogger(UnsafeSupport.class);
        String javaSpecVersion = System.getProperty("java.specification.version");
        logger.debug("Starting UnsafeSupport init in Java " + javaSpecVersion);
        ByteBuffer direct = ByteBuffer.allocateDirect(1);
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            maybeUnsafe = unsafeField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            maybeUnsafe = e;
        }
        if (maybeUnsafe instanceof Throwable) {
            unsafe = null;
            logger.debug("Unsafe unavailable - Could not get it via Field sun.misc.Unsafe.theUnsafe", (Throwable)maybeUnsafe);
        } else {
            unsafe = (Unsafe)maybeUnsafe;
            logger.trace("sun.misc.Unsafe.theUnsafe ok");
        }
        if (unsafe != null) {
            Exception maybeException;
            finalUnsafe = unsafe;
            try {
                finalUnsafe.getClass().getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                maybeException = null;
            }
            catch (NoSuchMethodException | SecurityException e) {
                maybeException = e;
            }
            if (maybeException == null) {
                logger.trace("sun.misc.Unsafe.copyMemory ok");
            } else {
                unsafe = null;
                logger.debug("Unsafe unavailable - failed on sun.misc.Unsafe.copyMemory", maybeException);
            }
        }
        if (unsafe != null) {
            Object maybeAddressField;
            finalUnsafe = unsafe;
            try {
                Field field = Buffer.class.getDeclaredField("address");
                long offset = finalUnsafe.objectFieldOffset(field);
                long heapAddress = finalUnsafe.getLong(ByteBuffer.allocate(1), offset);
                long directAddress = finalUnsafe.getLong(direct, offset);
                maybeAddressField = heapAddress != 0L && "1.8".equals(javaSpecVersion) ? new IllegalStateException("A heap buffer must have 0 address in Java 8, got " + heapAddress) : (heapAddress == 0L && !"1.8".equals(javaSpecVersion) ? new IllegalStateException("A heap buffer must have non-zero address in Java " + javaSpecVersion) : (directAddress == 0L ? new IllegalStateException("A direct buffer must have non-zero address") : field));
            }
            catch (NoSuchFieldException | SecurityException e) {
                maybeAddressField = e;
            }
            if (maybeAddressField instanceof Throwable) {
                logger.debug("Unsafe unavailable - failed on java.nio.Buffer.address", (Throwable)maybeAddressField);
                unsafe = null;
            } else {
                logger.trace("java.nio.Buffer.address ok");
                logger.debug("Unsafe is available");
            }
        }
        UNSAFE = unsafe;
    }
}

