/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.event;

import io.lettuce.core.event.Event;
import io.lettuce.core.event.EventBus;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;

public class DefaultEventBus
implements EventBus {
    private final EmitterProcessor<Event> bus = EmitterProcessor.create();
    private final Scheduler scheduler;

    public DefaultEventBus(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Flux<Event> get() {
        return this.bus.onBackpressureDrop().publishOn(this.scheduler);
    }

    @Override
    public void publish(Event event) {
        if (this.bus.hasDownstreams()) {
            this.bus.onNext((Object)event);
        }
    }
}

