/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import io.kubernetes.client.util.WebSockets;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import okhttp3.WebSocket;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketStreamHandler
implements WebSockets.SocketListener,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(WebSocketStreamHandler.class);
    private final Map<Integer, PipedInputStream> input = new HashMap<Integer, PipedInputStream>();
    private final Map<Integer, PipedOutputStream> pipedOutput = new HashMap<Integer, PipedOutputStream>();
    private final Map<Integer, OutputStream> output = new HashMap<Integer, OutputStream>();
    private WebSocket socket;
    private Throwable error;
    private String protocol;
    private State state = State.UNINITIALIZED;

    public synchronized void waitForInitialized() throws InterruptedException {
        if (this.state != State.UNINITIALIZED) {
            return;
        }
        this.wait();
    }

    @Override
    public synchronized void open(String protocol, WebSocket socket) {
        if (this.state != State.UNINITIALIZED) {
            throw new IllegalStateException();
        }
        this.protocol = protocol;
        this.socket = socket;
        this.state = State.OPEN;
        this.notifyAll();
    }

    @Override
    public void bytesMessage(InputStream in) {
        try {
            this.handleMessage(in.read(), in);
        }
        catch (IOException ex) {
            log.error("Error reading message channel", (Throwable)ex);
        }
    }

    @Override
    public void textMessage(Reader in) {
        try {
            this.handleMessage(in.read(), new ByteArrayInputStream(CharStreams.toString((Readable)in).getBytes(Charsets.UTF_8)));
        }
        catch (IOException ex) {
            log.error("Error writing message", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(int stream, InputStream inStream) throws IOException {
        try {
            OutputStream out = this.getSocketInputOutputStream(stream);
            ByteStreams.copy((InputStream)inStream, (OutputStream)out);
            out.flush();
        }
        finally {
            inStream.close();
        }
    }

    @Override
    public void failure(Throwable t) {
        this.error = t;
    }

    public Throwable getError() {
        return this.error;
    }

    @Override
    public synchronized void close() {
        if (this.state != State.CLOSED) {
            this.state = State.CLOSED;
            if (null != this.socket) {
                this.socket.close(1000, "Triggered client-side terminate");
                log.debug("Successfully closed socket.");
            }
            for (PipedOutputStream pipedOutputStream : this.pipedOutput.values()) {
                try {
                    pipedOutputStream.flush();
                }
                catch (IOException ex) {
                    log.error("Error on flush", (Throwable)ex);
                }
                try {
                    pipedOutputStream.close();
                }
                catch (IOException ex) {
                    log.error("Error on close", (Throwable)ex);
                }
            }
            for (OutputStream outputStream : this.output.values()) {
                try {
                    outputStream.flush();
                }
                catch (IOException ex) {
                    log.error("Error on flush", (Throwable)ex);
                }
                try {
                    outputStream.close();
                }
                catch (IOException ex) {
                    log.error("Error on close", (Throwable)ex);
                }
            }
        }
        this.notifyAll();
    }

    public synchronized InputStream getInputStream(int stream) {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException();
        }
        if (!this.input.containsKey(stream)) {
            try {
                PipedInputStream pipeIn = new PipedInputStream();
                PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
                this.pipedOutput.put(stream, pipeOut);
                this.input.put(stream, pipeIn);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.input.get(stream);
    }

    public synchronized OutputStream getOutputStream(int stream) {
        if (!this.output.containsKey(stream)) {
            this.output.put(stream, new WebSocketOutputStream(stream));
        }
        return this.output.get(stream);
    }

    private synchronized OutputStream getSocketInputOutputStream(int stream) {
        if (!this.pipedOutput.containsKey(stream)) {
            try {
                PipedInputStream pipeIn = new PipedInputStream();
                PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
                this.pipedOutput.put(stream, pipeOut);
                this.input.put(stream, pipeIn);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.pipedOutput.get(stream);
    }

    private class WebSocketOutputStream
    extends OutputStream {
        private final byte stream;

        public WebSocketOutputStream(int stream) {
            this.stream = (byte)stream;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            if (WebSocketStreamHandler.this.socket == null) {
                WebSocketStreamHandler webSocketStreamHandler = WebSocketStreamHandler.this;
                synchronized (webSocketStreamHandler) {
                    if (WebSocketStreamHandler.this.state == State.CLOSED) {
                        throw new IllegalStateException();
                    }
                    if (WebSocketStreamHandler.this.socket == null) {
                        try {
                            WebSocketStreamHandler.this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException();
                        }
                    }
                }
            }
            byte[] buffer = new byte[length + 1];
            buffer[0] = this.stream;
            System.arraycopy(b, offset, buffer, 1, length);
            WebSocketStreamHandler.this.socket.send(ByteString.of((byte[])buffer));
        }
    }

    private static enum State {
        UNINITIALIZED,
        OPEN,
        CLOSED;

    }
}

