package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.custom.Quantity;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1ExternalMetricSourceFluentImpl<A extends V2beta1ExternalMetricSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta1ExternalMetricSourceFluent<A>{

    private String metricName;
    private V1LabelSelectorBuilder metricSelector;
    private Quantity targetAverageValue;
    private Quantity targetValue;

    public V2beta1ExternalMetricSourceFluentImpl(){
    }
    public V2beta1ExternalMetricSourceFluentImpl(V2beta1ExternalMetricSource instance){
            this.withMetricName(instance.getMetricName());

            this.withMetricSelector(instance.getMetricSelector());

            this.withTargetAverageValue(instance.getTargetAverageValue());

            this.withTargetValue(instance.getTargetValue());

    }

    public String getMetricName(){
            return this.metricName;
    }

    public A withMetricName(String metricName){
            this.metricName=metricName; return (A) this;
    }

    public Boolean hasMetricName(){
            return this.metricName != null;
    }

    public A withNewMetricName(String arg1){
            return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuilder arg1){
            return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuffer arg1){
            return (A)withMetricName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetricSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getMetricSelector(){
            return this.metricSelector!=null?this.metricSelector.build():null;
    }

    public V1LabelSelector buildMetricSelector(){
            return this.metricSelector!=null?this.metricSelector.build():null;
    }

    public A withMetricSelector(V1LabelSelector metricSelector){
            _visitables.get("metricSelector").remove(this.metricSelector);
            if (metricSelector!=null){ this.metricSelector= new V1LabelSelectorBuilder(metricSelector); _visitables.get("metricSelector").add(this.metricSelector);} return (A) this;
    }

    public Boolean hasMetricSelector(){
            return this.metricSelector != null;
    }

    public V2beta1ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelector(){
            return new MetricSelectorNestedImpl();
    }

    public V2beta1ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelectorLike(V1LabelSelector item){
            return new MetricSelectorNestedImpl(item);
    }

    public V2beta1ExternalMetricSourceFluent.MetricSelectorNested<A> editMetricSelector(){
            return withNewMetricSelectorLike(getMetricSelector());
    }

    public V2beta1ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelector(){
            return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): new V1LabelSelectorBuilder().build());
    }

    public V2beta1ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(V1LabelSelector item){
            return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): item);
    }

    public Quantity getTargetAverageValue(){
            return this.targetAverageValue;
    }

    public A withTargetAverageValue(Quantity targetAverageValue){
            this.targetAverageValue=targetAverageValue; return (A) this;
    }

    public Boolean hasTargetAverageValue(){
            return this.targetAverageValue != null;
    }

    public A withNewTargetAverageValue(final String value){
            return (A)withTargetAverageValue(new Quantity(value));
    }

    public Quantity getTargetValue(){
            return this.targetValue;
    }

    public A withTargetValue(Quantity targetValue){
            this.targetValue=targetValue; return (A) this;
    }

    public Boolean hasTargetValue(){
            return this.targetValue != null;
    }

    public A withNewTargetValue(final String value){
            return (A)withTargetValue(new Quantity(value));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V2beta1ExternalMetricSourceFluentImpl that = (V2beta1ExternalMetricSourceFluentImpl) o;
            if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
            if (metricSelector != null ? !metricSelector.equals(that.metricSelector) :that.metricSelector != null) return false;
            if (targetAverageValue != null ? !targetAverageValue.equals(that.targetAverageValue) :that.targetAverageValue != null) return false;
            if (targetValue != null ? !targetValue.equals(that.targetValue) :that.targetValue != null) return false;
            return true;
    }


    public class MetricSelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V2beta1ExternalMetricSourceFluent.MetricSelectorNested<N>> implements V2beta1ExternalMetricSourceFluent.MetricSelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            MetricSelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            MetricSelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V2beta1ExternalMetricSourceFluentImpl.this.withMetricSelector(builder.build());
    }
    public N endMetricSelector(){
            return and();
    }

}


}
