package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class V1beta1EndpointFluentImpl<A extends V1beta1EndpointFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1EndpointFluent<A>{

    private List<String> addresses;
    private V1beta1EndpointConditionsBuilder conditions;
    private String hostname;
    private V1ObjectReferenceBuilder targetRef;
    private Map<String,String> topology;

    public V1beta1EndpointFluentImpl(){
    }
    public V1beta1EndpointFluentImpl(V1beta1Endpoint instance){
            this.withAddresses(instance.getAddresses());

            this.withConditions(instance.getConditions());

            this.withHostname(instance.getHostname());

            this.withTargetRef(instance.getTargetRef());

            this.withTopology(instance.getTopology());

    }

    public A addToAddresses(int index,String item){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            this.addresses.add(index, item);
            return (A)this;
    }

    public A setToAddresses(int index,String item){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            this.addresses.set(index, item); return (A)this;
    }

    public A addToAddresses(String... items){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            for (String item : items) {this.addresses.add(item);} return (A)this;
    }

    public A addAllToAddresses(Collection<String> items){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            for (String item : items) {this.addresses.add(item);} return (A)this;
    }

    public A removeFromAddresses(String... items){
            for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
    }

    public A removeAllFromAddresses(Collection<String> items){
            for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
    }

    public List<String> getAddresses(){
            return this.addresses;
    }

    public String getAddress(int index){
            return this.addresses.get(index);
    }

    public String getFirstAddress(){
            return this.addresses.get(0);
    }

    public String getLastAddress(){
            return this.addresses.get(addresses.size() - 1);
    }

    public String getMatchingAddress(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: addresses) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAddress(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: addresses) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAddresses(List<String> addresses){
            if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
            if (addresses != null) {this.addresses = new ArrayList<String>(); for (String item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
    }

    public A withAddresses(String... addresses){
            if (this.addresses != null) {this.addresses.clear();}
            if (addresses != null) {for (String item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public Boolean hasAddresses(){
            return addresses != null && !addresses.isEmpty();
    }

    public A addNewAddress(String arg1){
            return (A)addToAddresses(new String(arg1));
    }

    public A addNewAddress(StringBuilder arg1){
            return (A)addToAddresses(new String(arg1));
    }

    public A addNewAddress(StringBuffer arg1){
            return (A)addToAddresses(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1EndpointConditions getConditions(){
            return this.conditions!=null?this.conditions.build():null;
    }

    public V1beta1EndpointConditions buildConditions(){
            return this.conditions!=null?this.conditions.build():null;
    }

    public A withConditions(V1beta1EndpointConditions conditions){
            _visitables.get("conditions").remove(this.conditions);
            if (conditions!=null){ this.conditions= new V1beta1EndpointConditionsBuilder(conditions); _visitables.get("conditions").add(this.conditions);} return (A) this;
    }

    public Boolean hasConditions(){
            return this.conditions != null;
    }

    public V1beta1EndpointFluent.ConditionsNested<A> withNewConditions(){
            return new ConditionsNestedImpl();
    }

    public V1beta1EndpointFluent.ConditionsNested<A> withNewConditionsLike(V1beta1EndpointConditions item){
            return new ConditionsNestedImpl(item);
    }

    public V1beta1EndpointFluent.ConditionsNested<A> editConditions(){
            return withNewConditionsLike(getConditions());
    }

    public V1beta1EndpointFluent.ConditionsNested<A> editOrNewConditions(){
            return withNewConditionsLike(getConditions() != null ? getConditions(): new V1beta1EndpointConditionsBuilder().build());
    }

    public V1beta1EndpointFluent.ConditionsNested<A> editOrNewConditionsLike(V1beta1EndpointConditions item){
            return withNewConditionsLike(getConditions() != null ? getConditions(): item);
    }

    public String getHostname(){
            return this.hostname;
    }

    public A withHostname(String hostname){
            this.hostname=hostname; return (A) this;
    }

    public Boolean hasHostname(){
            return this.hostname != null;
    }

    public A withNewHostname(String arg1){
            return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuilder arg1){
            return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuffer arg1){
            return (A)withHostname(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getTargetRef(){
            return this.targetRef!=null?this.targetRef.build():null;
    }

    public V1ObjectReference buildTargetRef(){
            return this.targetRef!=null?this.targetRef.build():null;
    }

    public A withTargetRef(V1ObjectReference targetRef){
            _visitables.get("targetRef").remove(this.targetRef);
            if (targetRef!=null){ this.targetRef= new V1ObjectReferenceBuilder(targetRef); _visitables.get("targetRef").add(this.targetRef);} return (A) this;
    }

    public Boolean hasTargetRef(){
            return this.targetRef != null;
    }

    public V1beta1EndpointFluent.TargetRefNested<A> withNewTargetRef(){
            return new TargetRefNestedImpl();
    }

    public V1beta1EndpointFluent.TargetRefNested<A> withNewTargetRefLike(V1ObjectReference item){
            return new TargetRefNestedImpl(item);
    }

    public V1beta1EndpointFluent.TargetRefNested<A> editTargetRef(){
            return withNewTargetRefLike(getTargetRef());
    }

    public V1beta1EndpointFluent.TargetRefNested<A> editOrNewTargetRef(){
            return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): new V1ObjectReferenceBuilder().build());
    }

    public V1beta1EndpointFluent.TargetRefNested<A> editOrNewTargetRefLike(V1ObjectReference item){
            return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): item);
    }

    public A addToTopology(String key,String value){
            if(this.topology == null && key != null && value != null) { this.topology = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.topology.put(key, value);} return (A)this;
    }

    public A addToTopology(Map<String,String> map){
            if(this.topology == null && map != null) { this.topology = new LinkedHashMap<String,String>(); }
            if(map != null) { this.topology.putAll(map);} return (A)this;
    }

    public A removeFromTopology(String key){
            if(this.topology == null) { return (A) this; }
            if(key != null && this.topology != null) {this.topology.remove(key);} return (A)this;
    }

    public A removeFromTopology(Map<String,String> map){
            if(this.topology == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.topology != null){this.topology.remove(key);}}} return (A)this;
    }

    public Map<String,String> getTopology(){
            return this.topology;
    }

    public A withTopology(Map<String,String> topology){
            if (topology == null) { this.topology =  null;} else {this.topology = new LinkedHashMap<String,String>(topology);} return (A) this;
    }

    public Boolean hasTopology(){
            return this.topology != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1EndpointFluentImpl that = (V1beta1EndpointFluentImpl) o;
            if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
            if (targetRef != null ? !targetRef.equals(that.targetRef) :that.targetRef != null) return false;
            if (topology != null ? !topology.equals(that.topology) :that.topology != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends V1beta1EndpointConditionsFluentImpl<V1beta1EndpointFluent.ConditionsNested<N>> implements V1beta1EndpointFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1EndpointConditionsBuilder builder;
    
            ConditionsNestedImpl(V1beta1EndpointConditions item){
                    this.builder = new V1beta1EndpointConditionsBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.builder = new V1beta1EndpointConditionsBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1EndpointFluentImpl.this.withConditions(builder.build());
    }
    public N endConditions(){
            return and();
    }

}
    public class TargetRefNestedImpl<N> extends V1ObjectReferenceFluentImpl<V1beta1EndpointFluent.TargetRefNested<N>> implements V1beta1EndpointFluent.TargetRefNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectReferenceBuilder builder;
    
            TargetRefNestedImpl(V1ObjectReference item){
                    this.builder = new V1ObjectReferenceBuilder(this, item);
            }
            TargetRefNestedImpl(){
                    this.builder = new V1ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1EndpointFluentImpl.this.withTargetRef(builder.build());
    }
    public N endTargetRef(){
            return and();
    }

}


}
