package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface V1beta1EndpointFluent<A extends V1beta1EndpointFluent<A>> extends Fluent<A>{


    public A addToAddresses(int index,String item);
    public A setToAddresses(int index,String item);
    public A addToAddresses(String... items);
    public A addAllToAddresses(Collection<String> items);
    public A removeFromAddresses(String... items);
    public A removeAllFromAddresses(Collection<String> items);
    public List<String> getAddresses();
    public String getAddress(int index);
    public String getFirstAddress();
    public String getLastAddress();
    public String getMatchingAddress(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingAddress(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withAddresses(List<String> addresses);
    public A withAddresses(String... addresses);
    public Boolean hasAddresses();
    public A addNewAddress(String arg1);
    public A addNewAddress(StringBuilder arg1);
    public A addNewAddress(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1EndpointConditions getConditions();
    public V1beta1EndpointConditions buildConditions();
    public A withConditions(V1beta1EndpointConditions conditions);
    public Boolean hasConditions();
    public V1beta1EndpointFluent.ConditionsNested<A> withNewConditions();
    public V1beta1EndpointFluent.ConditionsNested<A> withNewConditionsLike(V1beta1EndpointConditions item);
    public V1beta1EndpointFluent.ConditionsNested<A> editConditions();
    public V1beta1EndpointFluent.ConditionsNested<A> editOrNewConditions();
    public V1beta1EndpointFluent.ConditionsNested<A> editOrNewConditionsLike(V1beta1EndpointConditions item);
    public String getHostname();
    public A withHostname(String hostname);
    public Boolean hasHostname();
    public A withNewHostname(String arg1);
    public A withNewHostname(StringBuilder arg1);
    public A withNewHostname(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getTargetRef();
    public V1ObjectReference buildTargetRef();
    public A withTargetRef(V1ObjectReference targetRef);
    public Boolean hasTargetRef();
    public V1beta1EndpointFluent.TargetRefNested<A> withNewTargetRef();
    public V1beta1EndpointFluent.TargetRefNested<A> withNewTargetRefLike(V1ObjectReference item);
    public V1beta1EndpointFluent.TargetRefNested<A> editTargetRef();
    public V1beta1EndpointFluent.TargetRefNested<A> editOrNewTargetRef();
    public V1beta1EndpointFluent.TargetRefNested<A> editOrNewTargetRefLike(V1ObjectReference item);
    public A addToTopology(String key,String value);
    public A addToTopology(Map<String,String> map);
    public A removeFromTopology(String key);
    public A removeFromTopology(Map<String,String> map);
    public Map<String,String> getTopology();
    public A withTopology(Map<String,String> topology);
    public Boolean hasTopology();

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta1EndpointConditionsFluent<V1beta1EndpointFluent.ConditionsNested<N>>{

        
    public N and();    public N endConditions();
}
    public interface TargetRefNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectReferenceFluent<V1beta1EndpointFluent.TargetRefNested<N>>{

        
    public N and();    public N endTargetRef();
}


}
