package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta1CSIDriverSpecFluentImpl<A extends V1beta1CSIDriverSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CSIDriverSpecFluent<A>{

    private Boolean attachRequired;
    private Boolean podInfoOnMount;
    private List<String> volumeLifecycleModes;

    public V1beta1CSIDriverSpecFluentImpl(){
    }
    public V1beta1CSIDriverSpecFluentImpl(V1beta1CSIDriverSpec instance){
            this.withAttachRequired(instance.getAttachRequired());

            this.withPodInfoOnMount(instance.getPodInfoOnMount());

            this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes());

    }

    public Boolean isAttachRequired(){
            return this.attachRequired;
    }

    public A withAttachRequired(Boolean attachRequired){
            this.attachRequired=attachRequired; return (A) this;
    }

    public Boolean hasAttachRequired(){
            return this.attachRequired != null;
    }

    public A withNewAttachRequired(String arg1){
            return (A)withAttachRequired(new Boolean(arg1));
    }

    public A withNewAttachRequired(boolean arg1){
            return (A)withAttachRequired(new Boolean(arg1));
    }

    public Boolean isPodInfoOnMount(){
            return this.podInfoOnMount;
    }

    public A withPodInfoOnMount(Boolean podInfoOnMount){
            this.podInfoOnMount=podInfoOnMount; return (A) this;
    }

    public Boolean hasPodInfoOnMount(){
            return this.podInfoOnMount != null;
    }

    public A withNewPodInfoOnMount(String arg1){
            return (A)withPodInfoOnMount(new Boolean(arg1));
    }

    public A withNewPodInfoOnMount(boolean arg1){
            return (A)withPodInfoOnMount(new Boolean(arg1));
    }

    public A addToVolumeLifecycleModes(int index,String item){
            if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
            this.volumeLifecycleModes.add(index, item);
            return (A)this;
    }

    public A setToVolumeLifecycleModes(int index,String item){
            if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
            this.volumeLifecycleModes.set(index, item); return (A)this;
    }

    public A addToVolumeLifecycleModes(String... items){
            if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
            for (String item : items) {this.volumeLifecycleModes.add(item);} return (A)this;
    }

    public A addAllToVolumeLifecycleModes(Collection<String> items){
            if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
            for (String item : items) {this.volumeLifecycleModes.add(item);} return (A)this;
    }

    public A removeFromVolumeLifecycleModes(String... items){
            for (String item : items) {if (this.volumeLifecycleModes!= null){ this.volumeLifecycleModes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumeLifecycleModes(Collection<String> items){
            for (String item : items) {if (this.volumeLifecycleModes!= null){ this.volumeLifecycleModes.remove(item);}} return (A)this;
    }

    public List<String> getVolumeLifecycleModes(){
            return this.volumeLifecycleModes;
    }

    public String getVolumeLifecycleMode(int index){
            return this.volumeLifecycleModes.get(index);
    }

    public String getFirstVolumeLifecycleMode(){
            return this.volumeLifecycleModes.get(0);
    }

    public String getLastVolumeLifecycleMode(){
            return this.volumeLifecycleModes.get(volumeLifecycleModes.size() - 1);
    }

    public String getMatchingVolumeLifecycleMode(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: volumeLifecycleModes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolumeLifecycleMode(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: volumeLifecycleModes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumeLifecycleModes(List<String> volumeLifecycleModes){
            if (this.volumeLifecycleModes != null) { _visitables.get("volumeLifecycleModes").removeAll(this.volumeLifecycleModes);}
            if (volumeLifecycleModes != null) {this.volumeLifecycleModes = new ArrayList<String>(); for (String item : volumeLifecycleModes){this.addToVolumeLifecycleModes(item);}} else { this.volumeLifecycleModes = null;} return (A) this;
    }

    public A withVolumeLifecycleModes(String... volumeLifecycleModes){
            if (this.volumeLifecycleModes != null) {this.volumeLifecycleModes.clear();}
            if (volumeLifecycleModes != null) {for (String item :volumeLifecycleModes){ this.addToVolumeLifecycleModes(item);}} return (A) this;
    }

    public Boolean hasVolumeLifecycleModes(){
            return volumeLifecycleModes != null && !volumeLifecycleModes.isEmpty();
    }

    public A addNewVolumeLifecycleMode(String arg1){
            return (A)addToVolumeLifecycleModes(new String(arg1));
    }

    public A addNewVolumeLifecycleMode(StringBuilder arg1){
            return (A)addToVolumeLifecycleModes(new String(arg1));
    }

    public A addNewVolumeLifecycleMode(StringBuffer arg1){
            return (A)addToVolumeLifecycleModes(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1CSIDriverSpecFluentImpl that = (V1beta1CSIDriverSpecFluentImpl) o;
            if (attachRequired != null ? !attachRequired.equals(that.attachRequired) :that.attachRequired != null) return false;
            if (podInfoOnMount != null ? !podInfoOnMount.equals(that.podInfoOnMount) :that.podInfoOnMount != null) return false;
            if (volumeLifecycleModes != null ? !volumeLifecycleModes.equals(that.volumeLifecycleModes) :that.volumeLifecycleModes != null) return false;
            return true;
    }




}
