package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PriorityLevelConfigurationReferenceBuilder extends V1alpha1PriorityLevelConfigurationReferenceFluentImpl<V1alpha1PriorityLevelConfigurationReferenceBuilder> implements VisitableBuilder<V1alpha1PriorityLevelConfigurationReference,V1alpha1PriorityLevelConfigurationReferenceBuilder>{

    V1alpha1PriorityLevelConfigurationReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PriorityLevelConfigurationReferenceBuilder(){
            this(true);
    }
    public V1alpha1PriorityLevelConfigurationReferenceBuilder(Boolean validationEnabled){
            this(new V1alpha1PriorityLevelConfigurationReference(), validationEnabled);
    }
    public V1alpha1PriorityLevelConfigurationReferenceBuilder(V1alpha1PriorityLevelConfigurationReferenceFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PriorityLevelConfigurationReferenceBuilder(V1alpha1PriorityLevelConfigurationReferenceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PriorityLevelConfigurationReference(), validationEnabled);
    }
    public V1alpha1PriorityLevelConfigurationReferenceBuilder(V1alpha1PriorityLevelConfigurationReferenceFluent<?> fluent,V1alpha1PriorityLevelConfigurationReference instance){
            this(fluent, instance, true);
    }
    public V1alpha1PriorityLevelConfigurationReferenceBuilder(V1alpha1PriorityLevelConfigurationReferenceFluent<?> fluent,V1alpha1PriorityLevelConfigurationReference instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PriorityLevelConfigurationReferenceBuilder(V1alpha1PriorityLevelConfigurationReference instance){
            this(instance,true);
    }
    public V1alpha1PriorityLevelConfigurationReferenceBuilder(V1alpha1PriorityLevelConfigurationReference instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PriorityLevelConfigurationReference build(){
            V1alpha1PriorityLevelConfigurationReference buildable = new V1alpha1PriorityLevelConfigurationReference();
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PriorityLevelConfigurationReferenceBuilder that = (V1alpha1PriorityLevelConfigurationReferenceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
