package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ClusterRoleBindingBuilder extends V1alpha1ClusterRoleBindingFluentImpl<V1alpha1ClusterRoleBindingBuilder> implements VisitableBuilder<V1alpha1ClusterRoleBinding,V1alpha1ClusterRoleBindingBuilder>{

    V1alpha1ClusterRoleBindingFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ClusterRoleBindingBuilder(){
            this(true);
    }
    public V1alpha1ClusterRoleBindingBuilder(Boolean validationEnabled){
            this(new V1alpha1ClusterRoleBinding(), validationEnabled);
    }
    public V1alpha1ClusterRoleBindingBuilder(V1alpha1ClusterRoleBindingFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ClusterRoleBindingBuilder(V1alpha1ClusterRoleBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ClusterRoleBinding(), validationEnabled);
    }
    public V1alpha1ClusterRoleBindingBuilder(V1alpha1ClusterRoleBindingFluent<?> fluent,V1alpha1ClusterRoleBinding instance){
            this(fluent, instance, true);
    }
    public V1alpha1ClusterRoleBindingBuilder(V1alpha1ClusterRoleBindingFluent<?> fluent,V1alpha1ClusterRoleBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withRoleRef(instance.getRoleRef());

            fluent.withSubjects(instance.getSubjects());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ClusterRoleBindingBuilder(V1alpha1ClusterRoleBinding instance){
            this(instance,true);
    }
    public V1alpha1ClusterRoleBindingBuilder(V1alpha1ClusterRoleBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withRoleRef(instance.getRoleRef());

            this.withSubjects(instance.getSubjects());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ClusterRoleBinding build(){
            V1alpha1ClusterRoleBinding buildable = new V1alpha1ClusterRoleBinding();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setRoleRef(fluent.getRoleRef());
            buildable.setSubjects(fluent.getSubjects());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ClusterRoleBindingBuilder that = (V1alpha1ClusterRoleBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
