package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1SubjectAccessReviewStatusBuilder extends V1SubjectAccessReviewStatusFluentImpl<V1SubjectAccessReviewStatusBuilder> implements VisitableBuilder<V1SubjectAccessReviewStatus,V1SubjectAccessReviewStatusBuilder>{

    V1SubjectAccessReviewStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1SubjectAccessReviewStatusBuilder(){
            this(true);
    }
    public V1SubjectAccessReviewStatusBuilder(Boolean validationEnabled){
            this(new V1SubjectAccessReviewStatus(), validationEnabled);
    }
    public V1SubjectAccessReviewStatusBuilder(V1SubjectAccessReviewStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1SubjectAccessReviewStatusBuilder(V1SubjectAccessReviewStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1SubjectAccessReviewStatus(), validationEnabled);
    }
    public V1SubjectAccessReviewStatusBuilder(V1SubjectAccessReviewStatusFluent<?> fluent,V1SubjectAccessReviewStatus instance){
            this(fluent, instance, true);
    }
    public V1SubjectAccessReviewStatusBuilder(V1SubjectAccessReviewStatusFluent<?> fluent,V1SubjectAccessReviewStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAllowed(instance.getAllowed());

            fluent.withDenied(instance.getDenied());

            fluent.withEvaluationError(instance.getEvaluationError());

            fluent.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }
    public V1SubjectAccessReviewStatusBuilder(V1SubjectAccessReviewStatus instance){
            this(instance,true);
    }
    public V1SubjectAccessReviewStatusBuilder(V1SubjectAccessReviewStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAllowed(instance.getAllowed());

            this.withDenied(instance.getDenied());

            this.withEvaluationError(instance.getEvaluationError());

            this.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }

    public V1SubjectAccessReviewStatus build(){
            V1SubjectAccessReviewStatus buildable = new V1SubjectAccessReviewStatus();
            buildable.setAllowed(fluent.isAllowed());
            buildable.setDenied(fluent.isDenied());
            buildable.setEvaluationError(fluent.getEvaluationError());
            buildable.setReason(fluent.getReason());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1SubjectAccessReviewStatusBuilder that = (V1SubjectAccessReviewStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
