package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class V1PodSecurityContextFluentImpl<A extends V1PodSecurityContextFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1PodSecurityContextFluent<A>{

    private Long fsGroup;
    private String fsGroupChangePolicy;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private V1SELinuxOptionsBuilder seLinuxOptions;
    private List<Long> supplementalGroups;
    private List<V1SysctlBuilder> sysctls;
    private V1WindowsSecurityContextOptionsBuilder windowsOptions;

    public V1PodSecurityContextFluentImpl(){
    }
    public V1PodSecurityContextFluentImpl(V1PodSecurityContext instance){
            this.withFsGroup(instance.getFsGroup());

            this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());

            this.withRunAsGroup(instance.getRunAsGroup());

            this.withRunAsNonRoot(instance.getRunAsNonRoot());

            this.withRunAsUser(instance.getRunAsUser());

            this.withSeLinuxOptions(instance.getSeLinuxOptions());

            this.withSupplementalGroups(instance.getSupplementalGroups());

            this.withSysctls(instance.getSysctls());

            this.withWindowsOptions(instance.getWindowsOptions());

    }

    public Long getFsGroup(){
            return this.fsGroup;
    }

    public A withFsGroup(Long fsGroup){
            this.fsGroup=fsGroup; return (A) this;
    }

    public Boolean hasFsGroup(){
            return this.fsGroup != null;
    }

    public String getFsGroupChangePolicy(){
            return this.fsGroupChangePolicy;
    }

    public A withFsGroupChangePolicy(String fsGroupChangePolicy){
            this.fsGroupChangePolicy=fsGroupChangePolicy; return (A) this;
    }

    public Boolean hasFsGroupChangePolicy(){
            return this.fsGroupChangePolicy != null;
    }

    public A withNewFsGroupChangePolicy(String arg1){
            return (A)withFsGroupChangePolicy(new String(arg1));
    }

    public A withNewFsGroupChangePolicy(StringBuilder arg1){
            return (A)withFsGroupChangePolicy(new String(arg1));
    }

    public A withNewFsGroupChangePolicy(StringBuffer arg1){
            return (A)withFsGroupChangePolicy(new String(arg1));
    }

    public Long getRunAsGroup(){
            return this.runAsGroup;
    }

    public A withRunAsGroup(Long runAsGroup){
            this.runAsGroup=runAsGroup; return (A) this;
    }

    public Boolean hasRunAsGroup(){
            return this.runAsGroup != null;
    }

    public Boolean isRunAsNonRoot(){
            return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot){
            this.runAsNonRoot=runAsNonRoot; return (A) this;
    }

    public Boolean hasRunAsNonRoot(){
            return this.runAsNonRoot != null;
    }

    public A withNewRunAsNonRoot(String arg1){
            return (A)withRunAsNonRoot(new Boolean(arg1));
    }

    public A withNewRunAsNonRoot(boolean arg1){
            return (A)withRunAsNonRoot(new Boolean(arg1));
    }

    public Long getRunAsUser(){
            return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser){
            this.runAsUser=runAsUser; return (A) this;
    }

    public Boolean hasRunAsUser(){
            return this.runAsUser != null;
    }

    
/**
 * This method has been deprecated, please use method buildSeLinuxOptions instead.
 * @return The buildable object.
 */
@Deprecated public V1SELinuxOptions getSeLinuxOptions(){
            return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public V1SELinuxOptions buildSeLinuxOptions(){
            return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public A withSeLinuxOptions(V1SELinuxOptions seLinuxOptions){
            _visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
            if (seLinuxOptions!=null){ this.seLinuxOptions= new V1SELinuxOptionsBuilder(seLinuxOptions); _visitables.get("seLinuxOptions").add(this.seLinuxOptions);} return (A) this;
    }

    public Boolean hasSeLinuxOptions(){
            return this.seLinuxOptions != null;
    }

    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions(){
            return new SeLinuxOptionsNestedImpl();
    }

    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(V1SELinuxOptions item){
            return new SeLinuxOptionsNestedImpl(item);
    }

    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions(){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }

    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions(){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): new V1SELinuxOptionsBuilder().build());
    }

    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(V1SELinuxOptions item){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): item);
    }

    public A addToSupplementalGroups(int index,Long item){
            if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
            this.supplementalGroups.add(index, item);
            return (A)this;
    }

    public A setToSupplementalGroups(int index,Long item){
            if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
            this.supplementalGroups.set(index, item); return (A)this;
    }

    public A addToSupplementalGroups(Long... items){
            if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
            for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
    }

    public A addAllToSupplementalGroups(Collection<Long> items){
            if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
            for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
    }

    public A removeFromSupplementalGroups(Long... items){
            for (Long item : items) {if (this.supplementalGroups!= null){ this.supplementalGroups.remove(item);}} return (A)this;
    }

    public A removeAllFromSupplementalGroups(Collection<Long> items){
            for (Long item : items) {if (this.supplementalGroups!= null){ this.supplementalGroups.remove(item);}} return (A)this;
    }

    public List<Long> getSupplementalGroups(){
            return this.supplementalGroups;
    }

    public Long getSupplementalGroup(int index){
            return this.supplementalGroups.get(index);
    }

    public Long getFirstSupplementalGroup(){
            return this.supplementalGroups.get(0);
    }

    public Long getLastSupplementalGroup(){
            return this.supplementalGroups.get(supplementalGroups.size() - 1);
    }

    public Long getMatchingSupplementalGroup(io.kubernetes.client.fluent.Predicate<Long> predicate){
            for (Long item: supplementalGroups) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSupplementalGroup(io.kubernetes.client.fluent.Predicate<Long> predicate){
            for (Long item: supplementalGroups) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSupplementalGroups(List<Long> supplementalGroups){
            if (this.supplementalGroups != null) { _visitables.get("supplementalGroups").removeAll(this.supplementalGroups);}
            if (supplementalGroups != null) {this.supplementalGroups = new ArrayList<Long>(); for (Long item : supplementalGroups){this.addToSupplementalGroups(item);}} else { this.supplementalGroups = null;} return (A) this;
    }

    public A withSupplementalGroups(Long... supplementalGroups){
            if (this.supplementalGroups != null) {this.supplementalGroups.clear();}
            if (supplementalGroups != null) {for (Long item :supplementalGroups){ this.addToSupplementalGroups(item);}} return (A) this;
    }

    public Boolean hasSupplementalGroups(){
            return supplementalGroups != null && !supplementalGroups.isEmpty();
    }

    public A addToSysctls(int index,V1Sysctl item){
            if (this.sysctls == null) {this.sysctls = new ArrayList<V1SysctlBuilder>();}
            V1SysctlBuilder builder = new V1SysctlBuilder(item);_visitables.get("sysctls").add(index >= 0 ? index : _visitables.get("sysctls").size(), builder);this.sysctls.add(index >= 0 ? index : sysctls.size(), builder); return (A)this;
    }

    public A setToSysctls(int index,V1Sysctl item){
            if (this.sysctls == null) {this.sysctls = new ArrayList<V1SysctlBuilder>();}
            V1SysctlBuilder builder = new V1SysctlBuilder(item);
            if (index < 0 || index >= _visitables.get("sysctls").size()) { _visitables.get("sysctls").add(builder); } else { _visitables.get("sysctls").set(index, builder);}
            if (index < 0 || index >= sysctls.size()) { sysctls.add(builder); } else { sysctls.set(index, builder);}
             return (A)this;
    }

    public A addToSysctls(V1Sysctl... items){
            if (this.sysctls == null) {this.sysctls = new ArrayList<V1SysctlBuilder>();}
            for (V1Sysctl item : items) {V1SysctlBuilder builder = new V1SysctlBuilder(item);_visitables.get("sysctls").add(builder);this.sysctls.add(builder);} return (A)this;
    }

    public A addAllToSysctls(Collection<V1Sysctl> items){
            if (this.sysctls == null) {this.sysctls = new ArrayList<V1SysctlBuilder>();}
            for (V1Sysctl item : items) {V1SysctlBuilder builder = new V1SysctlBuilder(item);_visitables.get("sysctls").add(builder);this.sysctls.add(builder);} return (A)this;
    }

    public A removeFromSysctls(V1Sysctl... items){
            for (V1Sysctl item : items) {V1SysctlBuilder builder = new V1SysctlBuilder(item);_visitables.get("sysctls").remove(builder);if (this.sysctls != null) {this.sysctls.remove(builder);}} return (A)this;
    }

    public A removeAllFromSysctls(Collection<V1Sysctl> items){
            for (V1Sysctl item : items) {V1SysctlBuilder builder = new V1SysctlBuilder(item);_visitables.get("sysctls").remove(builder);if (this.sysctls != null) {this.sysctls.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSysctls(io.kubernetes.client.fluent.Predicate<V1SysctlBuilder> predicate){
            if (sysctls == null) return (A) this;
            final Iterator<V1SysctlBuilder> each = sysctls.iterator();
            final List visitables = _visitables.get("sysctls");
            while (each.hasNext()) {
              V1SysctlBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSysctls instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Sysctl> getSysctls(){
            return build(sysctls);
    }

    public List<V1Sysctl> buildSysctls(){
            return build(sysctls);
    }

    public V1Sysctl buildSysctl(int index){
            return this.sysctls.get(index).build();
    }

    public V1Sysctl buildFirstSysctl(){
            return this.sysctls.get(0).build();
    }

    public V1Sysctl buildLastSysctl(){
            return this.sysctls.get(sysctls.size() - 1).build();
    }

    public V1Sysctl buildMatchingSysctl(io.kubernetes.client.fluent.Predicate<V1SysctlBuilder> predicate){
            for (V1SysctlBuilder item: sysctls) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSysctl(io.kubernetes.client.fluent.Predicate<V1SysctlBuilder> predicate){
            for (V1SysctlBuilder item: sysctls) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSysctls(List<V1Sysctl> sysctls){
            if (this.sysctls != null) { _visitables.get("sysctls").removeAll(this.sysctls);}
            if (sysctls != null) {this.sysctls = new ArrayList<V1SysctlBuilder>(); for (V1Sysctl item : sysctls){this.addToSysctls(item);}} else { this.sysctls = null;} return (A) this;
    }

    public A withSysctls(V1Sysctl... sysctls){
            if (this.sysctls != null) {this.sysctls.clear();}
            if (sysctls != null) {for (V1Sysctl item :sysctls){ this.addToSysctls(item);}} return (A) this;
    }

    public Boolean hasSysctls(){
            return sysctls != null && !sysctls.isEmpty();
    }

    public V1PodSecurityContextFluent.SysctlsNested<A> addNewSysctl(){
            return new SysctlsNestedImpl();
    }

    public V1PodSecurityContextFluent.SysctlsNested<A> addNewSysctlLike(V1Sysctl item){
            return new SysctlsNestedImpl(-1, item);
    }

    public V1PodSecurityContextFluent.SysctlsNested<A> setNewSysctlLike(int index,V1Sysctl item){
            return new SysctlsNestedImpl(index, item);
    }

    public V1PodSecurityContextFluent.SysctlsNested<A> editSysctl(int index){
            if (sysctls.size() <= index) throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
            return setNewSysctlLike(index, buildSysctl(index));
    }

    public V1PodSecurityContextFluent.SysctlsNested<A> editFirstSysctl(){
            if (sysctls.size() == 0) throw new RuntimeException("Can't edit first sysctls. The list is empty.");
            return setNewSysctlLike(0, buildSysctl(0));
    }

    public V1PodSecurityContextFluent.SysctlsNested<A> editLastSysctl(){
            int index = sysctls.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last sysctls. The list is empty.");
            return setNewSysctlLike(index, buildSysctl(index));
    }

    public V1PodSecurityContextFluent.SysctlsNested<A> editMatchingSysctl(io.kubernetes.client.fluent.Predicate<V1SysctlBuilder> predicate){
            int index = -1;
            for (int i=0;i<sysctls.size();i++) { 
            if (predicate.apply(sysctls.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching sysctls. No match found.");
            return setNewSysctlLike(index, buildSysctl(index));
    }

    
/**
 * This method has been deprecated, please use method buildWindowsOptions instead.
 * @return The buildable object.
 */
@Deprecated public V1WindowsSecurityContextOptions getWindowsOptions(){
            return this.windowsOptions!=null?this.windowsOptions.build():null;
    }

    public V1WindowsSecurityContextOptions buildWindowsOptions(){
            return this.windowsOptions!=null?this.windowsOptions.build():null;
    }

    public A withWindowsOptions(V1WindowsSecurityContextOptions windowsOptions){
            _visitables.get("windowsOptions").remove(this.windowsOptions);
            if (windowsOptions!=null){ this.windowsOptions= new V1WindowsSecurityContextOptionsBuilder(windowsOptions); _visitables.get("windowsOptions").add(this.windowsOptions);} return (A) this;
    }

    public Boolean hasWindowsOptions(){
            return this.windowsOptions != null;
    }

    public V1PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions(){
            return new WindowsOptionsNestedImpl();
    }

    public V1PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(V1WindowsSecurityContextOptions item){
            return new WindowsOptionsNestedImpl(item);
    }

    public V1PodSecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions(){
            return withNewWindowsOptionsLike(getWindowsOptions());
    }

    public V1PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions(){
            return withNewWindowsOptionsLike(getWindowsOptions() != null ? getWindowsOptions(): new V1WindowsSecurityContextOptionsBuilder().build());
    }

    public V1PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(V1WindowsSecurityContextOptions item){
            return withNewWindowsOptionsLike(getWindowsOptions() != null ? getWindowsOptions(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1PodSecurityContextFluentImpl that = (V1PodSecurityContextFluentImpl) o;
            if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
            if (fsGroupChangePolicy != null ? !fsGroupChangePolicy.equals(that.fsGroupChangePolicy) :that.fsGroupChangePolicy != null) return false;
            if (runAsGroup != null ? !runAsGroup.equals(that.runAsGroup) :that.runAsGroup != null) return false;
            if (runAsNonRoot != null ? !runAsNonRoot.equals(that.runAsNonRoot) :that.runAsNonRoot != null) return false;
            if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
            if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
            if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
            if (sysctls != null ? !sysctls.equals(that.sysctls) :that.sysctls != null) return false;
            if (windowsOptions != null ? !windowsOptions.equals(that.windowsOptions) :that.windowsOptions != null) return false;
            return true;
    }


    public class SeLinuxOptionsNestedImpl<N> extends V1SELinuxOptionsFluentImpl<V1PodSecurityContextFluent.SeLinuxOptionsNested<N>> implements V1PodSecurityContextFluent.SeLinuxOptionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1SELinuxOptionsBuilder builder;
    
            SeLinuxOptionsNestedImpl(V1SELinuxOptions item){
                    this.builder = new V1SELinuxOptionsBuilder(this, item);
            }
            SeLinuxOptionsNestedImpl(){
                    this.builder = new V1SELinuxOptionsBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSecurityContextFluentImpl.this.withSeLinuxOptions(builder.build());
    }
    public N endSeLinuxOptions(){
            return and();
    }

}
    public class SysctlsNestedImpl<N> extends V1SysctlFluentImpl<V1PodSecurityContextFluent.SysctlsNested<N>> implements V1PodSecurityContextFluent.SysctlsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1SysctlBuilder builder;
        private final int index;
    
            SysctlsNestedImpl(int index,V1Sysctl item){
                    this.index = index;
                    this.builder = new V1SysctlBuilder(this, item);
            }
            SysctlsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1SysctlBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSecurityContextFluentImpl.this.setToSysctls(index,builder.build());
    }
    public N endSysctl(){
            return and();
    }

}
    public class WindowsOptionsNestedImpl<N> extends V1WindowsSecurityContextOptionsFluentImpl<V1PodSecurityContextFluent.WindowsOptionsNested<N>> implements V1PodSecurityContextFluent.WindowsOptionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1WindowsSecurityContextOptionsBuilder builder;
    
            WindowsOptionsNestedImpl(V1WindowsSecurityContextOptions item){
                    this.builder = new V1WindowsSecurityContextOptionsBuilder(this, item);
            }
            WindowsOptionsNestedImpl(){
                    this.builder = new V1WindowsSecurityContextOptionsBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSecurityContextFluentImpl.this.withWindowsOptions(builder.build());
    }
    public N endWindowsOptions(){
            return and();
    }

}


}
