package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.util.Collection;
import java.lang.StringBuilder;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.StringBuffer;

public interface V1ContainerFluent<A extends V1ContainerFluent<A>> extends Fluent<A>{


    public A addToArgs(int index,String item);
    public A setToArgs(int index,String item);
    public A addToArgs(String... items);
    public A addAllToArgs(Collection<String> items);
    public A removeFromArgs(String... items);
    public A removeAllFromArgs(Collection<String> items);
    public List<String> getArgs();
    public String getArg(int index);
    public String getFirstArg();
    public String getLastArg();
    public String getMatchingArg(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingArg(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withArgs(List<String> args);
    public A withArgs(String... args);
    public Boolean hasArgs();
    public A addNewArg(String arg1);
    public A addNewArg(StringBuilder arg1);
    public A addNewArg(StringBuffer arg1);
    public A addToCommand(int index,String item);
    public A setToCommand(int index,String item);
    public A addToCommand(String... items);
    public A addAllToCommand(Collection<String> items);
    public A removeFromCommand(String... items);
    public A removeAllFromCommand(Collection<String> items);
    public List<String> getCommand();
    public String getCommand(int index);
    public String getFirstCommand();
    public String getLastCommand();
    public String getMatchingCommand(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingCommand(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withCommand(List<String> command);
    public A withCommand(String... command);
    public Boolean hasCommand();
    public A addNewCommand(String arg1);
    public A addNewCommand(StringBuilder arg1);
    public A addNewCommand(StringBuffer arg1);
    public A addToEnv(int index,V1EnvVar item);
    public A setToEnv(int index,V1EnvVar item);
    public A addToEnv(V1EnvVar... items);
    public A addAllToEnv(Collection<V1EnvVar> items);
    public A removeFromEnv(V1EnvVar... items);
    public A removeAllFromEnv(Collection<V1EnvVar> items);
    public A removeMatchingFromEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEnv instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EnvVar> getEnv();
    public List<V1EnvVar> buildEnv();
    public V1EnvVar buildEnv(int index);
    public V1EnvVar buildFirstEnv();
    public V1EnvVar buildLastEnv();
    public V1EnvVar buildMatchingEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate);
    public Boolean hasMatchingEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate);
    public A withEnv(List<V1EnvVar> env);
    public A withEnv(V1EnvVar... env);
    public Boolean hasEnv();
    public V1ContainerFluent.EnvNested<A> addNewEnv();
    public V1ContainerFluent.EnvNested<A> addNewEnvLike(V1EnvVar item);
    public V1ContainerFluent.EnvNested<A> setNewEnvLike(int index,V1EnvVar item);
    public V1ContainerFluent.EnvNested<A> editEnv(int index);
    public V1ContainerFluent.EnvNested<A> editFirstEnv();
    public V1ContainerFluent.EnvNested<A> editLastEnv();
    public V1ContainerFluent.EnvNested<A> editMatchingEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate);
    public A addToEnvFrom(int index,V1EnvFromSource item);
    public A setToEnvFrom(int index,V1EnvFromSource item);
    public A addToEnvFrom(V1EnvFromSource... items);
    public A addAllToEnvFrom(Collection<V1EnvFromSource> items);
    public A removeFromEnvFrom(V1EnvFromSource... items);
    public A removeAllFromEnvFrom(Collection<V1EnvFromSource> items);
    public A removeMatchingFromEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEnvFrom instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EnvFromSource> getEnvFrom();
    public List<V1EnvFromSource> buildEnvFrom();
    public V1EnvFromSource buildEnvFrom(int index);
    public V1EnvFromSource buildFirstEnvFrom();
    public V1EnvFromSource buildLastEnvFrom();
    public V1EnvFromSource buildMatchingEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate);
    public Boolean hasMatchingEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate);
    public A withEnvFrom(List<V1EnvFromSource> envFrom);
    public A withEnvFrom(V1EnvFromSource... envFrom);
    public Boolean hasEnvFrom();
    public V1ContainerFluent.EnvFromNested<A> addNewEnvFrom();
    public V1ContainerFluent.EnvFromNested<A> addNewEnvFromLike(V1EnvFromSource item);
    public V1ContainerFluent.EnvFromNested<A> setNewEnvFromLike(int index,V1EnvFromSource item);
    public V1ContainerFluent.EnvFromNested<A> editEnvFrom(int index);
    public V1ContainerFluent.EnvFromNested<A> editFirstEnvFrom();
    public V1ContainerFluent.EnvFromNested<A> editLastEnvFrom();
    public V1ContainerFluent.EnvFromNested<A> editMatchingEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public String getImagePullPolicy();
    public A withImagePullPolicy(String imagePullPolicy);
    public Boolean hasImagePullPolicy();
    public A withNewImagePullPolicy(String arg1);
    public A withNewImagePullPolicy(StringBuilder arg1);
    public A withNewImagePullPolicy(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildLifecycle instead.
 * @return The buildable object.
 */
@Deprecated public V1Lifecycle getLifecycle();
    public V1Lifecycle buildLifecycle();
    public A withLifecycle(V1Lifecycle lifecycle);
    public Boolean hasLifecycle();
    public V1ContainerFluent.LifecycleNested<A> withNewLifecycle();
    public V1ContainerFluent.LifecycleNested<A> withNewLifecycleLike(V1Lifecycle item);
    public V1ContainerFluent.LifecycleNested<A> editLifecycle();
    public V1ContainerFluent.LifecycleNested<A> editOrNewLifecycle();
    public V1ContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(V1Lifecycle item);
    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public V1Probe getLivenessProbe();
    public V1Probe buildLivenessProbe();
    public A withLivenessProbe(V1Probe livenessProbe);
    public Boolean hasLivenessProbe();
    public V1ContainerFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public V1ContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(V1Probe item);
    public V1ContainerFluent.LivenessProbeNested<A> editLivenessProbe();
    public V1ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public V1ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(V1Probe item);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public A addToPorts(int index,V1ContainerPort item);
    public A setToPorts(int index,V1ContainerPort item);
    public A addToPorts(V1ContainerPort... items);
    public A addAllToPorts(Collection<V1ContainerPort> items);
    public A removeFromPorts(V1ContainerPort... items);
    public A removeAllFromPorts(Collection<V1ContainerPort> items);
    public A removeMatchingFromPorts(io.kubernetes.client.fluent.Predicate<V1ContainerPortBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ContainerPort> getPorts();
    public List<V1ContainerPort> buildPorts();
    public V1ContainerPort buildPort(int index);
    public V1ContainerPort buildFirstPort();
    public V1ContainerPort buildLastPort();
    public V1ContainerPort buildMatchingPort(io.kubernetes.client.fluent.Predicate<V1ContainerPortBuilder> predicate);
    public Boolean hasMatchingPort(io.kubernetes.client.fluent.Predicate<V1ContainerPortBuilder> predicate);
    public A withPorts(List<V1ContainerPort> ports);
    public A withPorts(V1ContainerPort... ports);
    public Boolean hasPorts();
    public V1ContainerFluent.PortsNested<A> addNewPort();
    public V1ContainerFluent.PortsNested<A> addNewPortLike(V1ContainerPort item);
    public V1ContainerFluent.PortsNested<A> setNewPortLike(int index,V1ContainerPort item);
    public V1ContainerFluent.PortsNested<A> editPort(int index);
    public V1ContainerFluent.PortsNested<A> editFirstPort();
    public V1ContainerFluent.PortsNested<A> editLastPort();
    public V1ContainerFluent.PortsNested<A> editMatchingPort(io.kubernetes.client.fluent.Predicate<V1ContainerPortBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public V1Probe getReadinessProbe();
    public V1Probe buildReadinessProbe();
    public A withReadinessProbe(V1Probe readinessProbe);
    public Boolean hasReadinessProbe();
    public V1ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public V1ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(V1Probe item);
    public V1ContainerFluent.ReadinessProbeNested<A> editReadinessProbe();
    public V1ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public V1ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(V1Probe item);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public V1ResourceRequirements getResources();
    public V1ResourceRequirements buildResources();
    public A withResources(V1ResourceRequirements resources);
    public Boolean hasResources();
    public V1ContainerFluent.ResourcesNested<A> withNewResources();
    public V1ContainerFluent.ResourcesNested<A> withNewResourcesLike(V1ResourceRequirements item);
    public V1ContainerFluent.ResourcesNested<A> editResources();
    public V1ContainerFluent.ResourcesNested<A> editOrNewResources();
    public V1ContainerFluent.ResourcesNested<A> editOrNewResourcesLike(V1ResourceRequirements item);
    
/**
 * This method has been deprecated, please use method buildSecurityContext instead.
 * @return The buildable object.
 */
@Deprecated public V1SecurityContext getSecurityContext();
    public V1SecurityContext buildSecurityContext();
    public A withSecurityContext(V1SecurityContext securityContext);
    public Boolean hasSecurityContext();
    public V1ContainerFluent.SecurityContextNested<A> withNewSecurityContext();
    public V1ContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(V1SecurityContext item);
    public V1ContainerFluent.SecurityContextNested<A> editSecurityContext();
    public V1ContainerFluent.SecurityContextNested<A> editOrNewSecurityContext();
    public V1ContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(V1SecurityContext item);
    
/**
 * This method has been deprecated, please use method buildStartupProbe instead.
 * @return The buildable object.
 */
@Deprecated public V1Probe getStartupProbe();
    public V1Probe buildStartupProbe();
    public A withStartupProbe(V1Probe startupProbe);
    public Boolean hasStartupProbe();
    public V1ContainerFluent.StartupProbeNested<A> withNewStartupProbe();
    public V1ContainerFluent.StartupProbeNested<A> withNewStartupProbeLike(V1Probe item);
    public V1ContainerFluent.StartupProbeNested<A> editStartupProbe();
    public V1ContainerFluent.StartupProbeNested<A> editOrNewStartupProbe();
    public V1ContainerFluent.StartupProbeNested<A> editOrNewStartupProbeLike(V1Probe item);
    public Boolean isStdin();
    public A withStdin(Boolean stdin);
    public Boolean hasStdin();
    public A withNewStdin(String arg1);
    public A withNewStdin(boolean arg1);
    public Boolean isStdinOnce();
    public A withStdinOnce(Boolean stdinOnce);
    public Boolean hasStdinOnce();
    public A withNewStdinOnce(String arg1);
    public A withNewStdinOnce(boolean arg1);
    public String getTerminationMessagePath();
    public A withTerminationMessagePath(String terminationMessagePath);
    public Boolean hasTerminationMessagePath();
    public A withNewTerminationMessagePath(String arg1);
    public A withNewTerminationMessagePath(StringBuilder arg1);
    public A withNewTerminationMessagePath(StringBuffer arg1);
    public String getTerminationMessagePolicy();
    public A withTerminationMessagePolicy(String terminationMessagePolicy);
    public Boolean hasTerminationMessagePolicy();
    public A withNewTerminationMessagePolicy(String arg1);
    public A withNewTerminationMessagePolicy(StringBuilder arg1);
    public A withNewTerminationMessagePolicy(StringBuffer arg1);
    public Boolean isTty();
    public A withTty(Boolean tty);
    public Boolean hasTty();
    public A withNewTty(String arg1);
    public A withNewTty(boolean arg1);
    public A addToVolumeDevices(int index,V1VolumeDevice item);
    public A setToVolumeDevices(int index,V1VolumeDevice item);
    public A addToVolumeDevices(V1VolumeDevice... items);
    public A addAllToVolumeDevices(Collection<V1VolumeDevice> items);
    public A removeFromVolumeDevices(V1VolumeDevice... items);
    public A removeAllFromVolumeDevices(Collection<V1VolumeDevice> items);
    public A removeMatchingFromVolumeDevices(io.kubernetes.client.fluent.Predicate<V1VolumeDeviceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumeDevices instead.
 * @return The buildable object.
 */
@Deprecated public List<V1VolumeDevice> getVolumeDevices();
    public List<V1VolumeDevice> buildVolumeDevices();
    public V1VolumeDevice buildVolumeDevice(int index);
    public V1VolumeDevice buildFirstVolumeDevice();
    public V1VolumeDevice buildLastVolumeDevice();
    public V1VolumeDevice buildMatchingVolumeDevice(io.kubernetes.client.fluent.Predicate<V1VolumeDeviceBuilder> predicate);
    public Boolean hasMatchingVolumeDevice(io.kubernetes.client.fluent.Predicate<V1VolumeDeviceBuilder> predicate);
    public A withVolumeDevices(List<V1VolumeDevice> volumeDevices);
    public A withVolumeDevices(V1VolumeDevice... volumeDevices);
    public Boolean hasVolumeDevices();
    public V1ContainerFluent.VolumeDevicesNested<A> addNewVolumeDevice();
    public V1ContainerFluent.VolumeDevicesNested<A> addNewVolumeDeviceLike(V1VolumeDevice item);
    public V1ContainerFluent.VolumeDevicesNested<A> setNewVolumeDeviceLike(int index,V1VolumeDevice item);
    public V1ContainerFluent.VolumeDevicesNested<A> editVolumeDevice(int index);
    public V1ContainerFluent.VolumeDevicesNested<A> editFirstVolumeDevice();
    public V1ContainerFluent.VolumeDevicesNested<A> editLastVolumeDevice();
    public V1ContainerFluent.VolumeDevicesNested<A> editMatchingVolumeDevice(io.kubernetes.client.fluent.Predicate<V1VolumeDeviceBuilder> predicate);
    public A addToVolumeMounts(int index,V1VolumeMount item);
    public A setToVolumeMounts(int index,V1VolumeMount item);
    public A addToVolumeMounts(V1VolumeMount... items);
    public A addAllToVolumeMounts(Collection<V1VolumeMount> items);
    public A removeFromVolumeMounts(V1VolumeMount... items);
    public A removeAllFromVolumeMounts(Collection<V1VolumeMount> items);
    public A removeMatchingFromVolumeMounts(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumeMounts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1VolumeMount> getVolumeMounts();
    public List<V1VolumeMount> buildVolumeMounts();
    public V1VolumeMount buildVolumeMount(int index);
    public V1VolumeMount buildFirstVolumeMount();
    public V1VolumeMount buildLastVolumeMount();
    public V1VolumeMount buildMatchingVolumeMount(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate);
    public Boolean hasMatchingVolumeMount(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate);
    public A withVolumeMounts(List<V1VolumeMount> volumeMounts);
    public A withVolumeMounts(V1VolumeMount... volumeMounts);
    public Boolean hasVolumeMounts();
    public V1ContainerFluent.VolumeMountsNested<A> addNewVolumeMount();
    public V1ContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(V1VolumeMount item);
    public V1ContainerFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,V1VolumeMount item);
    public V1ContainerFluent.VolumeMountsNested<A> editVolumeMount(int index);
    public V1ContainerFluent.VolumeMountsNested<A> editFirstVolumeMount();
    public V1ContainerFluent.VolumeMountsNested<A> editLastVolumeMount();
    public V1ContainerFluent.VolumeMountsNested<A> editMatchingVolumeMount(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate);
    public String getWorkingDir();
    public A withWorkingDir(String workingDir);
    public Boolean hasWorkingDir();
    public A withNewWorkingDir(String arg1);
    public A withNewWorkingDir(StringBuilder arg1);
    public A withNewWorkingDir(StringBuffer arg1);

    public interface EnvNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1EnvVarFluent<V1ContainerFluent.EnvNested<N>>{

        
    public N and();    public N endEnv();
}
    public interface EnvFromNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1EnvFromSourceFluent<V1ContainerFluent.EnvFromNested<N>>{

        
    public N and();    public N endEnvFrom();
}
    public interface LifecycleNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LifecycleFluent<V1ContainerFluent.LifecycleNested<N>>{

        
    public N and();    public N endLifecycle();
}
    public interface LivenessProbeNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ProbeFluent<V1ContainerFluent.LivenessProbeNested<N>>{

        
    public N and();    public N endLivenessProbe();
}
    public interface PortsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ContainerPortFluent<V1ContainerFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}
    public interface ReadinessProbeNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ProbeFluent<V1ContainerFluent.ReadinessProbeNested<N>>{

        
    public N and();    public N endReadinessProbe();
}
    public interface ResourcesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ResourceRequirementsFluent<V1ContainerFluent.ResourcesNested<N>>{

        
    public N and();    public N endResources();
}
    public interface SecurityContextNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1SecurityContextFluent<V1ContainerFluent.SecurityContextNested<N>>{

        
    public N and();    public N endSecurityContext();
}
    public interface StartupProbeNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ProbeFluent<V1ContainerFluent.StartupProbeNested<N>>{

        
    public N and();    public N endStartupProbe();
}
    public interface VolumeDevicesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1VolumeDeviceFluent<V1ContainerFluent.VolumeDevicesNested<N>>{

        
    public N and();    public N endVolumeDevice();
}
    public interface VolumeMountsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1VolumeMountFluent<V1ContainerFluent.VolumeMountsNested<N>>{

        
    public N and();    public N endVolumeMount();
}


}
