package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class ExtensionsV1beta1IngressSpecFluentImpl<A extends ExtensionsV1beta1IngressSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements ExtensionsV1beta1IngressSpecFluent<A>{

    private ExtensionsV1beta1IngressBackendBuilder backend;
    private String ingressClassName;
    private List<ExtensionsV1beta1IngressRuleBuilder> rules;
    private List<ExtensionsV1beta1IngressTLSBuilder> tls;

    public ExtensionsV1beta1IngressSpecFluentImpl(){
    }
    public ExtensionsV1beta1IngressSpecFluentImpl(ExtensionsV1beta1IngressSpec instance){
            this.withBackend(instance.getBackend());

            this.withIngressClassName(instance.getIngressClassName());

            this.withRules(instance.getRules());

            this.withTls(instance.getTls());

    }

    
/**
 * This method has been deprecated, please use method buildBackend instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1IngressBackend getBackend(){
            return this.backend!=null?this.backend.build():null;
    }

    public ExtensionsV1beta1IngressBackend buildBackend(){
            return this.backend!=null?this.backend.build():null;
    }

    public A withBackend(ExtensionsV1beta1IngressBackend backend){
            _visitables.get("backend").remove(this.backend);
            if (backend!=null){ this.backend= new ExtensionsV1beta1IngressBackendBuilder(backend); _visitables.get("backend").add(this.backend);} return (A) this;
    }

    public Boolean hasBackend(){
            return this.backend != null;
    }

    public ExtensionsV1beta1IngressSpecFluent.BackendNested<A> withNewBackend(){
            return new BackendNestedImpl();
    }

    public ExtensionsV1beta1IngressSpecFluent.BackendNested<A> withNewBackendLike(ExtensionsV1beta1IngressBackend item){
            return new BackendNestedImpl(item);
    }

    public ExtensionsV1beta1IngressSpecFluent.BackendNested<A> editBackend(){
            return withNewBackendLike(getBackend());
    }

    public ExtensionsV1beta1IngressSpecFluent.BackendNested<A> editOrNewBackend(){
            return withNewBackendLike(getBackend() != null ? getBackend(): new ExtensionsV1beta1IngressBackendBuilder().build());
    }

    public ExtensionsV1beta1IngressSpecFluent.BackendNested<A> editOrNewBackendLike(ExtensionsV1beta1IngressBackend item){
            return withNewBackendLike(getBackend() != null ? getBackend(): item);
    }

    public String getIngressClassName(){
            return this.ingressClassName;
    }

    public A withIngressClassName(String ingressClassName){
            this.ingressClassName=ingressClassName; return (A) this;
    }

    public Boolean hasIngressClassName(){
            return this.ingressClassName != null;
    }

    public A withNewIngressClassName(String arg1){
            return (A)withIngressClassName(new String(arg1));
    }

    public A withNewIngressClassName(StringBuilder arg1){
            return (A)withIngressClassName(new String(arg1));
    }

    public A withNewIngressClassName(StringBuffer arg1){
            return (A)withIngressClassName(new String(arg1));
    }

    public A addToRules(int index,ExtensionsV1beta1IngressRule item){
            if (this.rules == null) {this.rules = new ArrayList<ExtensionsV1beta1IngressRuleBuilder>();}
            ExtensionsV1beta1IngressRuleBuilder builder = new ExtensionsV1beta1IngressRuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,ExtensionsV1beta1IngressRule item){
            if (this.rules == null) {this.rules = new ArrayList<ExtensionsV1beta1IngressRuleBuilder>();}
            ExtensionsV1beta1IngressRuleBuilder builder = new ExtensionsV1beta1IngressRuleBuilder(item);
            if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
            if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
             return (A)this;
    }

    public A addToRules(ExtensionsV1beta1IngressRule... items){
            if (this.rules == null) {this.rules = new ArrayList<ExtensionsV1beta1IngressRuleBuilder>();}
            for (ExtensionsV1beta1IngressRule item : items) {ExtensionsV1beta1IngressRuleBuilder builder = new ExtensionsV1beta1IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<ExtensionsV1beta1IngressRule> items){
            if (this.rules == null) {this.rules = new ArrayList<ExtensionsV1beta1IngressRuleBuilder>();}
            for (ExtensionsV1beta1IngressRule item : items) {ExtensionsV1beta1IngressRuleBuilder builder = new ExtensionsV1beta1IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(ExtensionsV1beta1IngressRule... items){
            for (ExtensionsV1beta1IngressRule item : items) {ExtensionsV1beta1IngressRuleBuilder builder = new ExtensionsV1beta1IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<ExtensionsV1beta1IngressRule> items){
            for (ExtensionsV1beta1IngressRule item : items) {ExtensionsV1beta1IngressRuleBuilder builder = new ExtensionsV1beta1IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1IngressRuleBuilder> predicate){
            if (rules == null) return (A) this;
            final Iterator<ExtensionsV1beta1IngressRuleBuilder> each = rules.iterator();
            final List visitables = _visitables.get("rules");
            while (each.hasNext()) {
              ExtensionsV1beta1IngressRuleBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1IngressRule> getRules(){
            return build(rules);
    }

    public List<ExtensionsV1beta1IngressRule> buildRules(){
            return build(rules);
    }

    public ExtensionsV1beta1IngressRule buildRule(int index){
            return this.rules.get(index).build();
    }

    public ExtensionsV1beta1IngressRule buildFirstRule(){
            return this.rules.get(0).build();
    }

    public ExtensionsV1beta1IngressRule buildLastRule(){
            return this.rules.get(rules.size() - 1).build();
    }

    public ExtensionsV1beta1IngressRule buildMatchingRule(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1IngressRuleBuilder> predicate){
            for (ExtensionsV1beta1IngressRuleBuilder item: rules) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRule(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1IngressRuleBuilder> predicate){
            for (ExtensionsV1beta1IngressRuleBuilder item: rules) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRules(List<ExtensionsV1beta1IngressRule> rules){
            if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
            if (rules != null) {this.rules = new ArrayList<ExtensionsV1beta1IngressRuleBuilder>(); for (ExtensionsV1beta1IngressRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(ExtensionsV1beta1IngressRule... rules){
            if (this.rules != null) {this.rules.clear();}
            if (rules != null) {for (ExtensionsV1beta1IngressRule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules(){
            return rules != null && !rules.isEmpty();
    }

    public ExtensionsV1beta1IngressSpecFluent.RulesNested<A> addNewRule(){
            return new RulesNestedImpl();
    }

    public ExtensionsV1beta1IngressSpecFluent.RulesNested<A> addNewRuleLike(ExtensionsV1beta1IngressRule item){
            return new RulesNestedImpl(-1, item);
    }

    public ExtensionsV1beta1IngressSpecFluent.RulesNested<A> setNewRuleLike(int index,ExtensionsV1beta1IngressRule item){
            return new RulesNestedImpl(index, item);
    }

    public ExtensionsV1beta1IngressSpecFluent.RulesNested<A> editRule(int index){
            if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
            return setNewRuleLike(index, buildRule(index));
    }

    public ExtensionsV1beta1IngressSpecFluent.RulesNested<A> editFirstRule(){
            if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
            return setNewRuleLike(0, buildRule(0));
    }

    public ExtensionsV1beta1IngressSpecFluent.RulesNested<A> editLastRule(){
            int index = rules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
            return setNewRuleLike(index, buildRule(index));
    }

    public ExtensionsV1beta1IngressSpecFluent.RulesNested<A> editMatchingRule(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1IngressRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<rules.size();i++) { 
            if (predicate.apply(rules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
            return setNewRuleLike(index, buildRule(index));
    }

    public A addToTls(int index,ExtensionsV1beta1IngressTLS item){
            if (this.tls == null) {this.tls = new ArrayList<ExtensionsV1beta1IngressTLSBuilder>();}
            ExtensionsV1beta1IngressTLSBuilder builder = new ExtensionsV1beta1IngressTLSBuilder(item);_visitables.get("tls").add(index >= 0 ? index : _visitables.get("tls").size(), builder);this.tls.add(index >= 0 ? index : tls.size(), builder); return (A)this;
    }

    public A setToTls(int index,ExtensionsV1beta1IngressTLS item){
            if (this.tls == null) {this.tls = new ArrayList<ExtensionsV1beta1IngressTLSBuilder>();}
            ExtensionsV1beta1IngressTLSBuilder builder = new ExtensionsV1beta1IngressTLSBuilder(item);
            if (index < 0 || index >= _visitables.get("tls").size()) { _visitables.get("tls").add(builder); } else { _visitables.get("tls").set(index, builder);}
            if (index < 0 || index >= tls.size()) { tls.add(builder); } else { tls.set(index, builder);}
             return (A)this;
    }

    public A addToTls(ExtensionsV1beta1IngressTLS... items){
            if (this.tls == null) {this.tls = new ArrayList<ExtensionsV1beta1IngressTLSBuilder>();}
            for (ExtensionsV1beta1IngressTLS item : items) {ExtensionsV1beta1IngressTLSBuilder builder = new ExtensionsV1beta1IngressTLSBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
    }

    public A addAllToTls(Collection<ExtensionsV1beta1IngressTLS> items){
            if (this.tls == null) {this.tls = new ArrayList<ExtensionsV1beta1IngressTLSBuilder>();}
            for (ExtensionsV1beta1IngressTLS item : items) {ExtensionsV1beta1IngressTLSBuilder builder = new ExtensionsV1beta1IngressTLSBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
    }

    public A removeFromTls(ExtensionsV1beta1IngressTLS... items){
            for (ExtensionsV1beta1IngressTLS item : items) {ExtensionsV1beta1IngressTLSBuilder builder = new ExtensionsV1beta1IngressTLSBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
    }

    public A removeAllFromTls(Collection<ExtensionsV1beta1IngressTLS> items){
            for (ExtensionsV1beta1IngressTLS item : items) {ExtensionsV1beta1IngressTLSBuilder builder = new ExtensionsV1beta1IngressTLSBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTls(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1IngressTLSBuilder> predicate){
            if (tls == null) return (A) this;
            final Iterator<ExtensionsV1beta1IngressTLSBuilder> each = tls.iterator();
            final List visitables = _visitables.get("tls");
            while (each.hasNext()) {
              ExtensionsV1beta1IngressTLSBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1IngressTLS> getTls(){
            return build(tls);
    }

    public List<ExtensionsV1beta1IngressTLS> buildTls(){
            return build(tls);
    }

    public ExtensionsV1beta1IngressTLS buildTl(int index){
            return this.tls.get(index).build();
    }

    public ExtensionsV1beta1IngressTLS buildFirstTl(){
            return this.tls.get(0).build();
    }

    public ExtensionsV1beta1IngressTLS buildLastTl(){
            return this.tls.get(tls.size() - 1).build();
    }

    public ExtensionsV1beta1IngressTLS buildMatchingTl(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1IngressTLSBuilder> predicate){
            for (ExtensionsV1beta1IngressTLSBuilder item: tls) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTl(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1IngressTLSBuilder> predicate){
            for (ExtensionsV1beta1IngressTLSBuilder item: tls) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTls(List<ExtensionsV1beta1IngressTLS> tls){
            if (this.tls != null) { _visitables.get("tls").removeAll(this.tls);}
            if (tls != null) {this.tls = new ArrayList<ExtensionsV1beta1IngressTLSBuilder>(); for (ExtensionsV1beta1IngressTLS item : tls){this.addToTls(item);}} else { this.tls = null;} return (A) this;
    }

    public A withTls(ExtensionsV1beta1IngressTLS... tls){
            if (this.tls != null) {this.tls.clear();}
            if (tls != null) {for (ExtensionsV1beta1IngressTLS item :tls){ this.addToTls(item);}} return (A) this;
    }

    public Boolean hasTls(){
            return tls != null && !tls.isEmpty();
    }

    public ExtensionsV1beta1IngressSpecFluent.TlsNested<A> addNewTl(){
            return new TlsNestedImpl();
    }

    public ExtensionsV1beta1IngressSpecFluent.TlsNested<A> addNewTlLike(ExtensionsV1beta1IngressTLS item){
            return new TlsNestedImpl(-1, item);
    }

    public ExtensionsV1beta1IngressSpecFluent.TlsNested<A> setNewTlLike(int index,ExtensionsV1beta1IngressTLS item){
            return new TlsNestedImpl(index, item);
    }

    public ExtensionsV1beta1IngressSpecFluent.TlsNested<A> editTl(int index){
            if (tls.size() <= index) throw new RuntimeException("Can't edit tls. Index exceeds size.");
            return setNewTlLike(index, buildTl(index));
    }

    public ExtensionsV1beta1IngressSpecFluent.TlsNested<A> editFirstTl(){
            if (tls.size() == 0) throw new RuntimeException("Can't edit first tls. The list is empty.");
            return setNewTlLike(0, buildTl(0));
    }

    public ExtensionsV1beta1IngressSpecFluent.TlsNested<A> editLastTl(){
            int index = tls.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tls. The list is empty.");
            return setNewTlLike(index, buildTl(index));
    }

    public ExtensionsV1beta1IngressSpecFluent.TlsNested<A> editMatchingTl(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1IngressTLSBuilder> predicate){
            int index = -1;
            for (int i=0;i<tls.size();i++) { 
            if (predicate.apply(tls.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tls. No match found.");
            return setNewTlLike(index, buildTl(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExtensionsV1beta1IngressSpecFluentImpl that = (ExtensionsV1beta1IngressSpecFluentImpl) o;
            if (backend != null ? !backend.equals(that.backend) :that.backend != null) return false;
            if (ingressClassName != null ? !ingressClassName.equals(that.ingressClassName) :that.ingressClassName != null) return false;
            if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            return true;
    }


    public class BackendNestedImpl<N> extends ExtensionsV1beta1IngressBackendFluentImpl<ExtensionsV1beta1IngressSpecFluent.BackendNested<N>> implements ExtensionsV1beta1IngressSpecFluent.BackendNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1IngressBackendBuilder builder;
    
            BackendNestedImpl(ExtensionsV1beta1IngressBackend item){
                    this.builder = new ExtensionsV1beta1IngressBackendBuilder(this, item);
            }
            BackendNestedImpl(){
                    this.builder = new ExtensionsV1beta1IngressBackendBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1IngressSpecFluentImpl.this.withBackend(builder.build());
    }
    public N endBackend(){
            return and();
    }

}
    public class RulesNestedImpl<N> extends ExtensionsV1beta1IngressRuleFluentImpl<ExtensionsV1beta1IngressSpecFluent.RulesNested<N>> implements ExtensionsV1beta1IngressSpecFluent.RulesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1IngressRuleBuilder builder;
        private final int index;
    
            RulesNestedImpl(int index,ExtensionsV1beta1IngressRule item){
                    this.index = index;
                    this.builder = new ExtensionsV1beta1IngressRuleBuilder(this, item);
            }
            RulesNestedImpl(){
                    this.index = -1;
                    this.builder = new ExtensionsV1beta1IngressRuleBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1IngressSpecFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule(){
            return and();
    }

}
    public class TlsNestedImpl<N> extends ExtensionsV1beta1IngressTLSFluentImpl<ExtensionsV1beta1IngressSpecFluent.TlsNested<N>> implements ExtensionsV1beta1IngressSpecFluent.TlsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1IngressTLSBuilder builder;
        private final int index;
    
            TlsNestedImpl(int index,ExtensionsV1beta1IngressTLS item){
                    this.index = index;
                    this.builder = new ExtensionsV1beta1IngressTLSBuilder(this, item);
            }
            TlsNestedImpl(){
                    this.index = -1;
                    this.builder = new ExtensionsV1beta1IngressTLSBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1IngressSpecFluentImpl.this.setToTls(index,builder.build());
    }
    public N endTl(){
            return and();
    }

}


}
