/*
 * Decompiled with CFR 0.152.
 */
package io.ikfly.service;

import io.ikfly.constant.OutputFormat;
import io.ikfly.exceptions.TtsException;
import io.ikfly.model.SSML;
import io.ikfly.model.SpeechConfig;
import io.ikfly.player.MyPlayer;
import io.ikfly.util.Tools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.UnsupportedAudioFileException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTSService {
    public static final Logger log = LoggerFactory.getLogger(TTSService.class);
    private String baseSavePath;
    private volatile OutputFormat outputFormat;
    private volatile String outputFileName;
    private volatile boolean usePlayer;
    private volatile boolean synthesising;
    private volatile String currentText;
    private final Buffer audioBuffer = new Buffer();
    private OkHttpClient okHttpClient;
    private WebSocket ws;
    protected WebSocketListener webSocketListener = new WebSocketListener(){

        public void onClosed(WebSocket webSocket, int code, String reason) {
            super.onClosed(webSocket, code, reason);
            log.debug("onClosed:" + reason);
            TTSService.this.ws = null;
            TTSService.this.synthesising = false;
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            super.onClosing(webSocket, code, reason);
            log.debug("onClosing:" + reason);
            TTSService.this.ws = null;
            TTSService.this.synthesising = false;
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            super.onFailure(webSocket, t, response);
            log.debug("onFailure" + t.getMessage(), t);
            TTSService.this.ws = null;
            TTSService.this.synthesising = false;
        }

        public void onMessage(WebSocket webSocket, String text) {
            super.onMessage(webSocket, text);
            if (text.contains("turn.start")) {
                TTSService.this.audioBuffer.clear();
            } else if (text.contains("turn.end")) {
                if (TTSService.this.outputFileName == null || "".equals(TTSService.this.outputFileName)) {
                    TTSService.this.outputFileName = (TTSService.this.currentText.length() < 6 ? TTSService.this.currentText : TTSService.this.currentText.substring(0, 5)).replaceAll("[</|*\u3002?\" >\\\\]", "") + Tools.localDateTime();
                }
                String absolutePath = TTSService.this.writeAudio(TTSService.this.outputFormat, TTSService.this.audioBuffer.readByteString(), TTSService.this.outputFileName);
                if (TTSService.this.usePlayer) {
                    try {
                        MyPlayer.getInstance(absolutePath).play(absolutePath);
                    }
                    catch (IOException | UnsupportedAudioFileException e) {
                        log.error(absolutePath + ":\u97f3\u9891\u64ad\u653e\u5931\u8d25," + e.getMessage(), (Throwable)e);
                    }
                }
                TTSService.this.synthesising = false;
                TTSService.this.usePlayer = false;
                TTSService.this.outputFileName = null;
            }
        }

        public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
            boolean audioContentType;
            super.onMessage(webSocket, bytes);
            int audioIndex = bytes.lastIndexOf("Path:audio\r\n".getBytes(StandardCharsets.UTF_8)) + "Path:audio\r\n".length();
            boolean bl = audioContentType = bytes.lastIndexOf("Content-Type:audio".getBytes(StandardCharsets.UTF_8)) + "Content-Type:audio".length() != -1;
            if (audioIndex != -1 && audioContentType) {
                try {
                    TTSService.this.audioBuffer.write(bytes.substring(audioIndex));
                }
                catch (Exception e) {
                    log.error("onMessage Error," + e.getMessage(), (Throwable)e);
                }
            }
        }
    };

    public String getBaseSavePath() {
        return this.baseSavePath;
    }

    public void setBaseSavePath(String baseSavePath) {
        this.baseSavePath = baseSavePath;
    }

    public TTSService() {
    }

    public TTSService(String baseSavePath) {
        this.baseSavePath = baseSavePath;
    }

    public void sendText(SSML ssml) {
        while (this.synthesising) {
            log.info("\u7a7a\u8f6c\u7b49\u5f85\u4e0a\u4e00\u4e2a\u8bed\u97f3\u5408\u6210");
            Tools.sleep(1);
        }
        this.synthesising = true;
        if (Objects.nonNull((Object)ssml.getOutputFormat()) && !ssml.getOutputFormat().equals((Object)this.outputFormat)) {
            this.sendConfig(ssml.getOutputFormat());
        }
        log.debug("ssml:{}", (Object)ssml);
        if (!this.getOrCreateWs().send(ssml.toString())) {
            throw TtsException.of("\u8bed\u97f3\u5408\u6210\u8bf7\u6c42\u53d1\u9001\u5931\u8d25...");
        }
        this.currentText = ssml.getSynthesisText();
        this.usePlayer = ssml.getUsePlayer();
        this.outputFileName = ssml.getOutputFileName();
    }

    public void close() {
        while (this.synthesising) {
            log.info("\u7a7a\u8f6c\u7b49\u5f85\u8bed\u97f3\u5408\u6210...");
            Tools.sleep(1);
        }
        if (Objects.nonNull(this.ws)) {
            this.ws.close(1000, "bye");
        }
        if (Objects.nonNull(this.okHttpClient)) {
            this.okHttpClient.dispatcher().executorService().shutdown();
            this.okHttpClient.connectionPool().evictAll();
        }
    }

    private synchronized WebSocket getOrCreateWs() {
        if (Objects.nonNull(this.ws)) {
            return this.ws;
        }
        String url = "wss://speech.platform.bing.com/consumer/speech/synthesize/readaloud/edge/v1?Retry-After=200&TrustedClientToken=6A5AA1D4EAFF4E9FB37E23D68491D6F4&ConnectionId=" + Tools.getRandomId();
        String origin = "chrome-extension://jdiccldimpdaibmpdkjnbmckianbfold";
        Request request = new Request.Builder().url(url).addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36 Edg/111.0.1661.44").addHeader("Origin", origin).build();
        this.ws = this.getOkHttpClient().newWebSocket(request, this.webSocketListener);
        this.sendConfig(this.outputFormat);
        return this.ws;
    }

    private OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            this.okHttpClient = new OkHttpClient.Builder().pingInterval(20L, TimeUnit.SECONDS).build();
        }
        return this.okHttpClient;
    }

    private void sendConfig(OutputFormat outputFormat) {
        SpeechConfig speechConfig = SpeechConfig.of(outputFormat);
        log.debug("audio config:{}", (Object)speechConfig);
        if (!this.getOrCreateWs().send(speechConfig.toString())) {
            throw TtsException.of("\u8bed\u97f3\u8f93\u51fa\u683c\u5f0f\u914d\u7f6e\u5931\u8d25...");
        }
        this.outputFormat = speechConfig.getOutputFormat();
    }

    private String writeAudio(OutputFormat format, ByteString data, String fileName) {
        try {
            byte[] audioBuffer = data.toByteArray();
            String[] split = format.getValue().split("-");
            String suffix = split[split.length - 1];
            String outputFileName = Optional.ofNullable(this.baseSavePath).orElse("") + fileName + "." + suffix;
            File outputAudioFile = new File(outputFileName);
            if (outputAudioFile.exists()) {
                outputAudioFile.delete();
            }
            FileOutputStream fstream = new FileOutputStream(outputAudioFile);
            fstream.write(audioBuffer);
            fstream.flush();
            fstream.close();
            return outputAudioFile.getAbsolutePath();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw TtsException.of("\u97f3\u9891\u6587\u4ef6\u5199\u51fa\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }
}

