/*
 * Decompiled with CFR 0.152.
 */
package io.ikfly.player;

import io.ikfly.exceptions.TtsException;
import io.ikfly.player.MyPlayer;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcmPlayer
implements MyPlayer {
    public static final Logger log = LoggerFactory.getLogger(PcmPlayer.class);

    @Override
    public void play(String path) throws IOException, UnsupportedAudioFileException {
        File file = new File(path);
        if (!file.exists()) {
            throw TtsException.of("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        AudioInputStream stream = AudioSystem.getAudioInputStream(file);
        this.playPcm(stream);
    }

    protected void playPcm(AudioInputStream stream) {
        AudioFormat target = stream.getFormat();
        DataLine.Info dinfo = new DataLine.Info(SourceDataLine.class, target, -1);
        SourceDataLine line = null;
        int len = -1;
        try {
            line = (SourceDataLine)AudioSystem.getLine(dinfo);
            line.open(target);
            line.start();
            byte[] buffer = new byte[1024];
            while ((len = stream.read(buffer)) > 0) {
                line.write(buffer, 0, len);
            }
            line.drain();
            line.stop();
            line.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

