/*
 * Decompiled with CFR 0.152.
 */
package io.ikfly.model;

import io.ikfly.constant.OutputFormat;
import io.ikfly.constant.VoiceEnum;
import io.ikfly.util.Tools;
import java.io.Serializable;
import java.util.Optional;

public class SSML
implements Serializable {
    public static String SSML_PATTERN = "X-RequestId:%s\r\nContent-Type:application/ssml+xml\r\nX-Timestamp:%sZ\r\nPath:ssml\r\n\r\n<speak version='1.0' xmlns='http://www.w3.org/2001/10/synthesis' xmlns:mstts='https://www.w3.org/2001/mstts' xml:lang='%s'>\r\n<voice name='%s'>\r\n<prosody pitch='+0Hz' rate='%s' volume='%s'>%s</prosody></voice></speak>";
    private String synthesisText;
    private VoiceEnum voice;
    private String rate;
    private String volume;
    private OutputFormat outputFormat;
    private String outputFileName;
    private boolean usePlayer;

    private SSML(String synthesisText, VoiceEnum voice, String rate, String volume, OutputFormat outputFormat, String outputFileName, boolean usePlayer) {
        this.synthesisText = synthesisText;
        this.voice = voice;
        this.rate = rate;
        this.volume = volume;
        this.outputFormat = outputFormat;
        this.outputFileName = outputFileName;
        this.usePlayer = usePlayer;
    }

    public static SSMLBuilder builder() {
        return new SSMLBuilder();
    }

    public String getSynthesisText() {
        return this.synthesisText;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public boolean getUsePlayer() {
        return this.usePlayer;
    }

    public String toString() {
        return String.format(SSML_PATTERN, Tools.getRandomId(), Tools.date(), Optional.ofNullable(this.voice).orElse(VoiceEnum.zh_CN_XiaoxiaoNeural).getLocale(), Optional.ofNullable(this.voice).orElse(VoiceEnum.zh_CN_XiaoxiaoNeural).getShortName(), Optional.ofNullable(this.rate).orElse("+0%"), Optional.ofNullable(this.volume).orElse("+0%"), this.synthesisText);
    }

    public static class SSMLBuilder {
        private String synthesisText;
        private VoiceEnum voice;
        private String rate;
        private String volume;
        private OutputFormat outputFormat;
        private String outputFileName;
        private boolean usePlayer;

        public SSMLBuilder synthesisText(String synthesisText) {
            this.synthesisText = synthesisText;
            return this;
        }

        public SSMLBuilder voice(VoiceEnum voice) {
            this.voice = voice;
            return this;
        }

        public SSMLBuilder rate(String rate) {
            this.rate = rate;
            return this;
        }

        public SSMLBuilder volume(String volume) {
            this.volume = volume;
            return this;
        }

        public SSMLBuilder outputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
            return this;
        }

        public SSMLBuilder outputFormat(OutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public SSMLBuilder usePlayer(boolean usePlayer) {
            this.usePlayer = usePlayer;
            return this;
        }

        public SSML build() {
            return new SSML(this.synthesisText, this.voice, this.rate, this.volume, this.outputFormat, this.outputFileName, this.usePlayer);
        }
    }
}

