package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.ConfigurationData;
import com.alipay.api.domain.OpenApiResponseHeader;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.trade.applepay.authentication.submit response.
 * 
 * @author auto create
 * @since 1.0, 2020-04-23 14:22:34
 */
public class AlipayTradeApplepayAuthenticationSubmitResponse extends AlipayResponse {

	private static final long serialVersionUID = 1817973966558521636L;

	/** 
	 * 核身错误信息
	 */
	@ApiField("authentication_error")
	private String authenticationError;

	/** 
	 * 配置数据
	 */
	@ApiField("configuration_data")
	private ConfigurationData configurationData;

	/** 
	 * 失败时的鉴权重试机制
	 */
	@ApiListField("fallback_authentication_mechanisms")
	@ApiField("string")
	private List<String> fallbackAuthenticationMechanisms;

	/** 
	 * applePay公用响应头
	 */
	@ApiField("response_header")
	private OpenApiResponseHeader responseHeader;

	/** 
	 * 鉴权重试机制
	 */
	@ApiListField("retry_authentication_mechanisms")
	@ApiField("string")
	private List<String> retryAuthenticationMechanisms;

	/** 
	 * 交易状态
	 */
	@ApiField("updated_transaction_status")
	private String updatedTransactionStatus;

	public void setAuthenticationError(String authenticationError) {
		this.authenticationError = authenticationError;
	}
	public String getAuthenticationError( ) {
		return this.authenticationError;
	}

	public void setConfigurationData(ConfigurationData configurationData) {
		this.configurationData = configurationData;
	}
	public ConfigurationData getConfigurationData( ) {
		return this.configurationData;
	}

	public void setFallbackAuthenticationMechanisms(List<String> fallbackAuthenticationMechanisms) {
		this.fallbackAuthenticationMechanisms = fallbackAuthenticationMechanisms;
	}
	public List<String> getFallbackAuthenticationMechanisms( ) {
		return this.fallbackAuthenticationMechanisms;
	}

	public void setResponseHeader(OpenApiResponseHeader responseHeader) {
		this.responseHeader = responseHeader;
	}
	public OpenApiResponseHeader getResponseHeader( ) {
		return this.responseHeader;
	}

	public void setRetryAuthenticationMechanisms(List<String> retryAuthenticationMechanisms) {
		this.retryAuthenticationMechanisms = retryAuthenticationMechanisms;
	}
	public List<String> getRetryAuthenticationMechanisms( ) {
		return this.retryAuthenticationMechanisms;
	}

	public void setUpdatedTransactionStatus(String updatedTransactionStatus) {
		this.updatedTransactionStatus = updatedTransactionStatus;
	}
	public String getUpdatedTransactionStatus( ) {
		return this.updatedTransactionStatus;
	}

}
