package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.overseas.tax.advanced.create response.
 * 
 * @author auto create
 * @since 1.0, 2020-03-30 17:51:12
 */
public class AlipayOverseasTaxAdvancedCreateResponse extends AlipayResponse {

	private static final long serialVersionUID = 8246372224712181746L;

	/** 
	 * 支付宝userId
	 */
	@ApiField("alipay_user_id")
	private String alipayUserId;

	/** 
	 * 线上预授权下单时返回，用于唤起收银台的参数
	 */
	@ApiField("order_str")
	private String orderStr;

	/** 
	 * 退税机构业务流水号，唯一，只能包含字母、数字
	 */
	@ApiField("out_tax_refund_no")
	private String outTaxRefundNo;

	/** 
	 * 支付宝退税资金订单号
	 */
	@ApiField("tax_refund_no")
	private String taxRefundNo;

	public void setAlipayUserId(String alipayUserId) {
		this.alipayUserId = alipayUserId;
	}
	public String getAlipayUserId( ) {
		return this.alipayUserId;
	}

	public void setOrderStr(String orderStr) {
		this.orderStr = orderStr;
	}
	public String getOrderStr( ) {
		return this.orderStr;
	}

	public void setOutTaxRefundNo(String outTaxRefundNo) {
		this.outTaxRefundNo = outTaxRefundNo;
	}
	public String getOutTaxRefundNo( ) {
		return this.outTaxRefundNo;
	}

	public void setTaxRefundNo(String taxRefundNo) {
		this.taxRefundNo = taxRefundNo;
	}
	public String getTaxRefundNo( ) {
		return this.taxRefundNo;
	}

}
