package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.SingleTripDurationResult;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.commerce.transport.singletrip.duration.query response.
 * 
 * @author auto create
 * @since 1.0, 2020-03-12 20:22:43
 */
public class AlipayCommerceTransportSingletripDurationQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 5557347562516858834L;

	/** 
	 * 扩展信息，json格式，由双方约定取值
	 */
	@ApiField("ext_info")
	private String extInfo;

	/** 
	 * 结果码，发生异常时非空
	 */
	@ApiField("result_code")
	private String resultCode;

	/** 
	 * 结果信息，发生异常时非空
	 */
	@ApiField("result_msg")
	private String resultMsg;

	/** 
	 * 服务任务类型（SYNC-同步，ASYNC-异步）
	 */
	@ApiField("service_task_type")
	private String serviceTaskType;

	/** 
	 * 单程时间查询结果集合
	 */
	@ApiListField("single_trip_duration_result_list")
	@ApiField("single_trip_duration_result")
	private List<SingleTripDurationResult> singleTripDurationResultList;

	public void setExtInfo(String extInfo) {
		this.extInfo = extInfo;
	}
	public String getExtInfo( ) {
		return this.extInfo;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}
	public String getResultCode( ) {
		return this.resultCode;
	}

	public void setResultMsg(String resultMsg) {
		this.resultMsg = resultMsg;
	}
	public String getResultMsg( ) {
		return this.resultMsg;
	}

	public void setServiceTaskType(String serviceTaskType) {
		this.serviceTaskType = serviceTaskType;
	}
	public String getServiceTaskType( ) {
		return this.serviceTaskType;
	}

	public void setSingleTripDurationResultList(List<SingleTripDurationResult> singleTripDurationResultList) {
		this.singleTripDurationResultList = singleTripDurationResultList;
	}
	public List<SingleTripDurationResult> getSingleTripDurationResultList( ) {
		return this.singleTripDurationResultList;
	}

}
