package com.alipay.api.response;

import java.util.Date;
import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.ServiceSubTask;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.commerce.transport.intelligentize.asynctask.query response.
 * 
 * @author auto create
 * @since 1.0, 2020-03-12 20:23:02
 */
public class AlipayCommerceTransportIntelligentizeAsynctaskQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 1367318584689626278L;

	/** 
	 * 服务任务结束时间，处理完成或处理失败前为空
	 */
	@ApiField("end_time")
	private Date endTime;

	/** 
	 * 扩展信息，json格式，由双方约定取值
	 */
	@ApiField("ext_info")
	private String extInfo;

	/** 
	 * 结果码，发生异常时非空
	 */
	@ApiField("result_code")
	private String resultCode;

	/** 
	 * 结果信息，发生异常时非空
	 */
	@ApiField("result_msg")
	private String resultMsg;

	/** 
	 * 服务任务ID
	 */
	@ApiField("service_task_id")
	private String serviceTaskId;

	/** 
	 * 服务任务执行结果，尚未处理成功或处理失败时为空
	 */
	@ApiField("service_task_result")
	private String serviceTaskResult;

	/** 
	 * 服务任务状态（INIT-初始，PROCESSING-处理中，FINISHED-处理完毕，FAILED-失败）
	 */
	@ApiField("service_task_status")
	private String serviceTaskStatus;

	/** 
	 * 服务任务开始时间，开始处理之前为空
	 */
	@ApiField("start_time")
	private Date startTime;

	/** 
	 * 服务子任务集合
	 */
	@ApiListField("sub_task_list")
	@ApiField("service_sub_task")
	private List<ServiceSubTask> subTaskList;

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}
	public Date getEndTime( ) {
		return this.endTime;
	}

	public void setExtInfo(String extInfo) {
		this.extInfo = extInfo;
	}
	public String getExtInfo( ) {
		return this.extInfo;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}
	public String getResultCode( ) {
		return this.resultCode;
	}

	public void setResultMsg(String resultMsg) {
		this.resultMsg = resultMsg;
	}
	public String getResultMsg( ) {
		return this.resultMsg;
	}

	public void setServiceTaskId(String serviceTaskId) {
		this.serviceTaskId = serviceTaskId;
	}
	public String getServiceTaskId( ) {
		return this.serviceTaskId;
	}

	public void setServiceTaskResult(String serviceTaskResult) {
		this.serviceTaskResult = serviceTaskResult;
	}
	public String getServiceTaskResult( ) {
		return this.serviceTaskResult;
	}

	public void setServiceTaskStatus(String serviceTaskStatus) {
		this.serviceTaskStatus = serviceTaskStatus;
	}
	public String getServiceTaskStatus( ) {
		return this.serviceTaskStatus;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}
	public Date getStartTime( ) {
		return this.startTime;
	}

	public void setSubTaskList(List<ServiceSubTask> subTaskList) {
		this.subTaskList = subTaskList;
	}
	public List<ServiceSubTask> getSubTaskList( ) {
		return this.subTaskList;
	}

}
