package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 周期扣款详细信息
 *
 * @author auto create
 * @since 1.0, 2020-04-24 14:21:49
 */
public class WithholdDetail extends AlipayObject {

	private static final long serialVersionUID = 5587179566279413519L;

	/**
	 * 扣款金额
	 */
	@ApiField("amount")
	private String amount;

	/**
	 * 当前扣款期数，1表示第一期
	 */
	@ApiField("current_period_index")
	private Long currentPeriodIndex;

	/**
	 * 扣款单号，每笔扣款单号唯一
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * Y-扣款成功   P-扣款处理中（即扣款重试中）   N-扣款失败（即扣款明确失败，已关单不再重试）
	 */
	@ApiField("status")
	private String status;

	/**
	 * 扣款总期数
	 */
	@ApiField("total_period_count")
	private Long totalPeriodCount;

	/**
	 * 支付宝交易号
	 */
	@ApiField("trade_no")
	private String tradeNo;

	/**
	 * 扣款成功时间，未扣款成功时此字段为空
	 */
	@ApiField("trans_dt")
	private Date transDt;

	public String getAmount() {
		return this.amount;
	}
	public void setAmount(String amount) {
		this.amount = amount;
	}

	public Long getCurrentPeriodIndex() {
		return this.currentPeriodIndex;
	}
	public void setCurrentPeriodIndex(Long currentPeriodIndex) {
		this.currentPeriodIndex = currentPeriodIndex;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

	public Long getTotalPeriodCount() {
		return this.totalPeriodCount;
	}
	public void setTotalPeriodCount(Long totalPeriodCount) {
		this.totalPeriodCount = totalPeriodCount;
	}

	public String getTradeNo() {
		return this.tradeNo;
	}
	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

	public Date getTransDt() {
		return this.transDt;
	}
	public void setTransDt(Date transDt) {
		this.transDt = transDt;
	}

}
