package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 时刻表线路信息
 *
 * @author auto create
 * @since 1.0, 2020-02-16 05:04:58
 */
public class TimeTableLineInfo extends AlipayObject {

	private static final long serialVersionUID = 2162651689427438147L;

	/**
	 * 期望车次总数
	 */
	@ApiField("expect_trip_count")
	private Long expectTripCount;

	/**
	 * 扩展参数，json格式，由双方约定取值
	 */
	@ApiField("ext_param")
	private String extParam;

	/**
	 * 线路方向，如：UP-上行，DOWN-下行，CIRCLE-环行
	 */
	@ApiField("line_direction")
	private String lineDirection;

	/**
	 * 线路key，同一条线路的上下行该值相同
	 */
	@ApiField("line_key")
	private String lineKey;

	/**
	 * 聚合时间粒度（单位：分钟），用于客流分析
	 */
	@ApiField("time_span")
	private Long timeSpan;

	/**
	 * 单车容量
	 */
	@ApiField("vehicle_capacity")
	private Long vehicleCapacity;

	/**
	 * 该行进方向的场站配车数，排班&轮班任务必填，时刻表任务可选
	 */
	@ApiField("vehicle_count")
	private Long vehicleCount;

	public Long getExpectTripCount() {
		return this.expectTripCount;
	}
	public void setExpectTripCount(Long expectTripCount) {
		this.expectTripCount = expectTripCount;
	}

	public String getExtParam() {
		return this.extParam;
	}
	public void setExtParam(String extParam) {
		this.extParam = extParam;
	}

	public String getLineDirection() {
		return this.lineDirection;
	}
	public void setLineDirection(String lineDirection) {
		this.lineDirection = lineDirection;
	}

	public String getLineKey() {
		return this.lineKey;
	}
	public void setLineKey(String lineKey) {
		this.lineKey = lineKey;
	}

	public Long getTimeSpan() {
		return this.timeSpan;
	}
	public void setTimeSpan(Long timeSpan) {
		this.timeSpan = timeSpan;
	}

	public Long getVehicleCapacity() {
		return this.vehicleCapacity;
	}
	public void setVehicleCapacity(Long vehicleCapacity) {
		this.vehicleCapacity = vehicleCapacity;
	}

	public Long getVehicleCount() {
		return this.vehicleCount;
	}
	public void setVehicleCount(Long vehicleCount) {
		this.vehicleCount = vehicleCount;
	}

}
