package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 大出行智能平台单程时间查询结果
 *
 * @author auto create
 * @since 1.0, 2020-02-16 04:19:27
 */
public class SingleTripDurationResult extends AlipayObject {

	private static final long serialVersionUID = 5787214634984644918L;

	/**
	 * 线路方向（UP-上行，DOWN-下行，CIRCLE-环行）
	 */
	@ApiField("line_direction")
	private String lineDirection;

	/**
	 * 线路key，同一条线路上下行该值相同
	 */
	@ApiField("line_key")
	private String lineKey;

	/**
	 * 发车时间段，英文半角逗号分隔，时间格式：HH24:mi:ss
	 */
	@ApiField("time_period")
	private String timePeriod;

	/**
	 * 单程行驶时间（单位：分钟）
	 */
	@ApiField("trip_duration")
	private Long tripDuration;

	public String getLineDirection() {
		return this.lineDirection;
	}
	public void setLineDirection(String lineDirection) {
		this.lineDirection = lineDirection;
	}

	public String getLineKey() {
		return this.lineKey;
	}
	public void setLineKey(String lineKey) {
		this.lineKey = lineKey;
	}

	public String getTimePeriod() {
		return this.timePeriod;
	}
	public void setTimePeriod(String timePeriod) {
		this.timePeriod = timePeriod;
	}

	public Long getTripDuration() {
		return this.tripDuration;
	}
	public void setTripDuration(Long tripDuration) {
		this.tripDuration = tripDuration;
	}

}
