package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 大出行智能平台服务子任务
 *
 * @author auto create
 * @since 1.0, 2020-02-16 05:02:28
 */
public class ServiceSubTask extends AlipayObject {

	private static final long serialVersionUID = 5384594212642578719L;

	/**
	 * 子任务结束时间，处理完成或处理失败前为空
	 */
	@ApiField("end_time")
	private Date endTime;

	/**
	 * 子任务结果码
	 */
	@ApiField("result_code")
	private String resultCode;

	/**
	 * 子任务结果信息
	 */
	@ApiField("result_msg")
	private String resultMsg;

	/**
	 * 子任务开始时间，开始处理之前为空
	 */
	@ApiField("start_time")
	private Date startTime;

	/**
	 * 服务子任务ID
	 */
	@ApiField("sub_task_id")
	private String subTaskId;

	/**
	 * 子任务状态（INIT-初始，PROCESSING-处理中，FINISHED-处理完毕，FAILED-失败）
	 */
	@ApiField("sub_task_status")
	private String subTaskStatus;

	public Date getEndTime() {
		return this.endTime;
	}
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getResultCode() {
		return this.resultCode;
	}
	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	public String getResultMsg() {
		return this.resultMsg;
	}
	public void setResultMsg(String resultMsg) {
		this.resultMsg = resultMsg;
	}

	public Date getStartTime() {
		return this.startTime;
	}
	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public String getSubTaskId() {
		return this.subTaskId;
	}
	public void setSubTaskId(String subTaskId) {
		this.subTaskId = subTaskId;
	}

	public String getSubTaskStatus() {
		return this.subTaskStatus;
	}
	public void setSubTaskStatus(String subTaskStatus) {
		this.subTaskStatus = subTaskStatus;
	}

}
