package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 充值营销
 *
 * @author auto create
 * @since 1.0, 2020-04-26 11:02:29
 */
public class RechargeDTO extends AlipayObject {

	private static final long serialVersionUID = 4777674349842218564L;

	/**
	 * 赠送金额
	 */
	@ApiField("gift_amount")
	private String giftAmount;

	/**
	 * 赠送份数
	 */
	@ApiField("gift_nums")
	private String giftNums;

	/**
	 * 赠送商品sku_id
	 */
	@ApiListField("gift_sku_id")
	@ApiField("string")
	private List<String> giftSkuId;

	/**
	 * 充值金额，必须是数字格式，支持两位小数
	 */
	@ApiField("recharge_amount")
	private String rechargeAmount;

	public String getGiftAmount() {
		return this.giftAmount;
	}
	public void setGiftAmount(String giftAmount) {
		this.giftAmount = giftAmount;
	}

	public String getGiftNums() {
		return this.giftNums;
	}
	public void setGiftNums(String giftNums) {
		this.giftNums = giftNums;
	}

	public List<String> getGiftSkuId() {
		return this.giftSkuId;
	}
	public void setGiftSkuId(List<String> giftSkuId) {
		this.giftSkuId = giftSkuId;
	}

	public String getRechargeAmount() {
		return this.rechargeAmount;
	}
	public void setRechargeAmount(String rechargeAmount) {
		this.rechargeAmount = rechargeAmount;
	}

}
