package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 奖品配置
 *
 * @author auto create
 * @since 1.0, 2020-04-17 20:12:45
 */
public class PrizeConfig extends AlipayObject {

	private static final long serialVersionUID = 2673374176545663921L;

	/**
	 * 总预算,目前仅支持个数预算
	 */
	@ApiField("amount")
	private String amount;

	/**
	 * 计次配置
	 */
	@ApiListField("count_control_config")
	@ApiField("count_control_config")
	private List<CountControlConfig> countControlConfig;

	/**
	 * 扩展参数
	 */
	@ApiField("ext_properties")
	private String extProperties;

	/**
	 * 奖品开始时间
	 */
	@ApiField("gmt_begin")
	private Date gmtBegin;

	/**
	 * 奖品结束时间
	 */
	@ApiField("gmt_end")
	private Date gmtEnd;

	/**
	 * 奖品id
	 */
	@ApiField("prize_id")
	private String prizeId;

	/**
	 * 奖品名称
	 */
	@ApiField("prize_name")
	private String prizeName;

	/**
	 * 奖品定价配置，目前只支持定额奖品
	 */
	@ApiField("prize_price_strategy")
	private PrizePriceStrategy prizePriceStrategy;

	/**
	 * 奖品类型,每一种值对应一种奖品类型
	 */
	@ApiField("prize_type")
	private String prizeType;

	/**
	 * 剩余预算,目前仅支持个数预算
	 */
	@ApiField("remain_amount")
	private String remainAmount;

	/**
	 * PRIZE_CREATED("PRIZE_CREATED", "已创建状态") PRIZE_OPENED("PRIZE_OPENED", "开启状态") PRIZE_PAUSED("PRIZE_PAUSED", "暂停状态") PRIZE_CLOSED("PRIZE_CLOSED", "关闭状态")
	 */
	@ApiField("status")
	private String status;

	public String getAmount() {
		return this.amount;
	}
	public void setAmount(String amount) {
		this.amount = amount;
	}

	public List<CountControlConfig> getCountControlConfig() {
		return this.countControlConfig;
	}
	public void setCountControlConfig(List<CountControlConfig> countControlConfig) {
		this.countControlConfig = countControlConfig;
	}

	public String getExtProperties() {
		return this.extProperties;
	}
	public void setExtProperties(String extProperties) {
		this.extProperties = extProperties;
	}

	public Date getGmtBegin() {
		return this.gmtBegin;
	}
	public void setGmtBegin(Date gmtBegin) {
		this.gmtBegin = gmtBegin;
	}

	public Date getGmtEnd() {
		return this.gmtEnd;
	}
	public void setGmtEnd(Date gmtEnd) {
		this.gmtEnd = gmtEnd;
	}

	public String getPrizeId() {
		return this.prizeId;
	}
	public void setPrizeId(String prizeId) {
		this.prizeId = prizeId;
	}

	public String getPrizeName() {
		return this.prizeName;
	}
	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}

	public PrizePriceStrategy getPrizePriceStrategy() {
		return this.prizePriceStrategy;
	}
	public void setPrizePriceStrategy(PrizePriceStrategy prizePriceStrategy) {
		this.prizePriceStrategy = prizePriceStrategy;
	}

	public String getPrizeType() {
		return this.prizeType;
	}
	public void setPrizeType(String prizeType) {
		this.prizeType = prizeType;
	}

	public String getRemainAmount() {
		return this.remainAmount;
	}
	public void setRemainAmount(String remainAmount) {
		this.remainAmount = remainAmount;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

}
