package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * PayOffOrderVO 待解付登记薄
 *
 * @author auto create
 * @since 1.0, 2020-04-14 14:39:30
 */
public class PayOffOrderVO extends AlipayObject {

	private static final long serialVersionUID = 5497238287952222574L;

	/**
	 * 待解付余额
	 */
	@ApiField("balance")
	private Money balance;

	/**
	 * 币种
	 */
	@ApiField("currency")
	private String currency;

	/**
	 * 是否高优先级处理
	 */
	@ApiField("is_high_priority")
	private Boolean isHighPriority;

	/**
	 * 待解付资金流水号
唯一键
	 */
	@ApiField("pay_off_no")
	private String payOffNo;

	/**
	 * 待解付登记薄状态
	 */
	@ApiField("status")
	private String status;

	public Money getBalance() {
		return this.balance;
	}
	public void setBalance(Money balance) {
		this.balance = balance;
	}

	public String getCurrency() {
		return this.currency;
	}
	public void setCurrency(String currency) {
		this.currency = currency;
	}

	public Boolean getIsHighPriority() {
		return this.isHighPriority;
	}
	public void setIsHighPriority(Boolean isHighPriority) {
		this.isHighPriority = isHighPriority;
	}

	public String getPayOffNo() {
		return this.payOffNo;
	}
	public void setPayOffNo(String payOffNo) {
		this.payOffNo = payOffNo;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

}
