package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 客流分析结果明细
 *
 * @author auto create
 * @since 1.0, 2020-02-16 01:06:26
 */
public class OdAnalysisResultDetail extends AlipayObject {

	private static final long serialVersionUID = 7785825578425426134L;

	/**
	 * 客流聚类结果分段，一般分为1-6段
	 */
	@ApiField("cluster_class")
	private String clusterClass;

	/**
	 * 客流下车站-日均下车人数
	 */
	@ApiField("end_station_daily_avg_load")
	private Long endStationDailyAvgLoad;

	/**
	 * 客流下车站-站点ID
	 */
	@ApiField("end_station_id")
	private String endStationId;

	/**
	 * 客流下车站-序号
	 */
	@ApiField("end_station_index")
	private String endStationIndex;

	/**
	 * 客流下车站-下车人数比例，如：25表示25%
	 */
	@ApiField("end_station_load_percent")
	private Long endStationLoadPercent;

	/**
	 * 客流下车站-名称
	 */
	@ApiField("end_station_name")
	private String endStationName;

	/**
	 * 客流上车站-日均上车人数
	 */
	@ApiField("start_station_daily_avg_load")
	private Long startStationDailyAvgLoad;

	/**
	 * 客流上车站-站点ID
	 */
	@ApiField("start_station_id")
	private String startStationId;

	/**
	 * 客流上车站-序号
	 */
	@ApiField("start_station_index")
	private Long startStationIndex;

	/**
	 * 客流上车站-名称
	 */
	@ApiField("start_station_name")
	private String startStationName;

	/**
	 * 发车时间段，英文半角逗号分隔，时间格式：HH24:mi:ss
	 */
	@ApiField("time_period")
	private String timePeriod;

	public String getClusterClass() {
		return this.clusterClass;
	}
	public void setClusterClass(String clusterClass) {
		this.clusterClass = clusterClass;
	}

	public Long getEndStationDailyAvgLoad() {
		return this.endStationDailyAvgLoad;
	}
	public void setEndStationDailyAvgLoad(Long endStationDailyAvgLoad) {
		this.endStationDailyAvgLoad = endStationDailyAvgLoad;
	}

	public String getEndStationId() {
		return this.endStationId;
	}
	public void setEndStationId(String endStationId) {
		this.endStationId = endStationId;
	}

	public String getEndStationIndex() {
		return this.endStationIndex;
	}
	public void setEndStationIndex(String endStationIndex) {
		this.endStationIndex = endStationIndex;
	}

	public Long getEndStationLoadPercent() {
		return this.endStationLoadPercent;
	}
	public void setEndStationLoadPercent(Long endStationLoadPercent) {
		this.endStationLoadPercent = endStationLoadPercent;
	}

	public String getEndStationName() {
		return this.endStationName;
	}
	public void setEndStationName(String endStationName) {
		this.endStationName = endStationName;
	}

	public Long getStartStationDailyAvgLoad() {
		return this.startStationDailyAvgLoad;
	}
	public void setStartStationDailyAvgLoad(Long startStationDailyAvgLoad) {
		this.startStationDailyAvgLoad = startStationDailyAvgLoad;
	}

	public String getStartStationId() {
		return this.startStationId;
	}
	public void setStartStationId(String startStationId) {
		this.startStationId = startStationId;
	}

	public Long getStartStationIndex() {
		return this.startStationIndex;
	}
	public void setStartStationIndex(Long startStationIndex) {
		this.startStationIndex = startStationIndex;
	}

	public String getStartStationName() {
		return this.startStationName;
	}
	public void setStartStationName(String startStationName) {
		this.startStationName = startStationName;
	}

	public String getTimePeriod() {
		return this.timePeriod;
	}
	public void setTimePeriod(String timePeriod) {
		this.timePeriod = timePeriod;
	}

}
