package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 商家会员卡信息
 *
 * @author auto create
 * @since 1.0, 2020-03-17 10:37:26
 */
public class MerchantMemberCardInfo extends AlipayObject {

	private static final long serialVersionUID = 7684294866239419473L;

	/**
	 * 会员卡类型: PREPAID, 储值卡; DISCOUNT: 折扣卡
	 */
	@ApiField("card_type")
	private String cardType;

	/**
	 * 折扣卡信息
	 */
	@ApiField("discount_info")
	private DiscountInfoVO discountInfo;

	/**
	 * 商户是否开通会员卡
	 */
	@ApiField("has_merchant_card")
	private Boolean hasMerchantCard;

	/**
	 * 储值卡信息
	 */
	@ApiListField("recharge_infos")
	@ApiField("recharge_info_v_o")
	private List<RechargeInfoVO> rechargeInfos;

	/**
	 * 店铺的名称
	 */
	@ApiField("shop_name")
	private String shopName;

	public String getCardType() {
		return this.cardType;
	}
	public void setCardType(String cardType) {
		this.cardType = cardType;
	}

	public DiscountInfoVO getDiscountInfo() {
		return this.discountInfo;
	}
	public void setDiscountInfo(DiscountInfoVO discountInfo) {
		this.discountInfo = discountInfo;
	}

	public Boolean getHasMerchantCard() {
		return this.hasMerchantCard;
	}
	public void setHasMerchantCard(Boolean hasMerchantCard) {
		this.hasMerchantCard = hasMerchantCard;
	}

	public List<RechargeInfoVO> getRechargeInfos() {
		return this.rechargeInfos;
	}
	public void setRechargeInfos(List<RechargeInfoVO> rechargeInfos) {
		this.rechargeInfos = rechargeInfos;
	}

	public String getShopName() {
		return this.shopName;
	}
	public void setShopName(String shopName) {
		this.shopName = shopName;
	}

}
