package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 检测实体
 *
 * @author auto create
 * @since 1.0, 2020-02-03 18:04:48
 */
public class DetectTaskService extends AlipayObject {

	private static final long serialVersionUID = 4371841843558161762L;

	/**
	 * 业务唯一id. 必传.如果再CI里面发起,传迭代id
	 */
	@ApiField("biz_uniq_id")
	private String bizUniqId;

	/**
	 * 扩展信息.如果是小程序，则必须传version属性
	 */
	@ApiField("extend_info_map")
	private String extendInfoMap;

	/**
	 * 服务名称. 必传
如果是小程序,传小程序名称.
 如果是H5,传服务名称.
	 */
	@ApiField("name")
	private String name;

	/**
	 * 服务url.
1) 如果是真个小程序的诊断,传alipays://platformapi/startapp?appId=#appId#, 如alipays://platformapi/startapp?appId=2019041063857386
  2) 如果是某个小程序页面的诊断,传该页面的具体路径: alipays://platformapi/startapp?appId=2018091261350219&page=/pages/h5pages/h5pages
3)如果是H5,传url, 如https://www.baidu.com
	 */
	@ApiField("page_url")
	private String pageUrl;

	public String getBizUniqId() {
		return this.bizUniqId;
	}
	public void setBizUniqId(String bizUniqId) {
		this.bizUniqId = bizUniqId;
	}

	public String getExtendInfoMap() {
		return this.extendInfoMap;
	}
	public void setExtendInfoMap(String extendInfoMap) {
		this.extendInfoMap = extendInfoMap;
	}

	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getPageUrl() {
		return this.pageUrl;
	}
	public void setPageUrl(String pageUrl) {
		this.pageUrl = pageUrl;
	}

}
