package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * AP发票邮寄记录
 *
 * @author auto create
 * @since 1.0, 2019-12-17 10:05:12
 */
public class ApInvoiceMailInfoVO extends AlipayObject {

	private static final long serialVersionUID = 3843133322577234569L;

	/**
	 * 创建人
	 */
	@ApiField("creator")
	private String creator;

	/**
	 * 快递公司名称
	 */
	@ApiField("express_company_name")
	private String expressCompanyName;

	/**
	 * 创建时间
	 */
	@ApiField("gmt_create")
	private Date gmtCreate;

	/**
	 * 修改时间
	 */
	@ApiField("gmt_modified")
	private Date gmtModified;

	/**
	 * 发票id
	 */
	@ApiField("invoice_id")
	private String invoiceId;

	/**
	 * 修改人
	 */
	@ApiField("last_modifier")
	private String lastModifier;

	/**
	 * 发票邮寄日期 格式yyyyMMdd
	 */
	@ApiField("mail_date")
	private String mailDate;

	/**
	 * 邮寄信息ID
	 */
	@ApiField("mail_id")
	private String mailId;

	/**
	 * 邮寄类型 01：商户邮寄 02：小二驳回邮寄
	 */
	@ApiField("mail_type")
	private String mailType;

	/**
	 * 邮寄原因
	 */
	@ApiField("reason")
	private String reason;

	/**
	 * 收件人地址
	 */
	@ApiField("recipients_address")
	private String recipientsAddress;

	/**
	 * 收件人名称
	 */
	@ApiField("recipients_name")
	private String recipientsName;

	/**
	 * 电话
	 */
	@ApiField("recipients_tel")
	private String recipientsTel;

	/**
	 * 寄件人地址
	 */
	@ApiField("sender_address")
	private String senderAddress;

	/**
	 * 寄件人名称
	 */
	@ApiField("sender_name")
	private String senderName;

	/**
	 * 寄件人电话
	 */
	@ApiField("sender_tel")
	private String senderTel;

	/**
	 * 租户机构id
	 */
	@ApiField("tnt_inst_id")
	private String tntInstId;

	/**
	 * 快递号
	 */
	@ApiField("tracking_no")
	private String trackingNo;

	public String getCreator() {
		return this.creator;
	}
	public void setCreator(String creator) {
		this.creator = creator;
	}

	public String getExpressCompanyName() {
		return this.expressCompanyName;
	}
	public void setExpressCompanyName(String expressCompanyName) {
		this.expressCompanyName = expressCompanyName;
	}

	public Date getGmtCreate() {
		return this.gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return this.gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getInvoiceId() {
		return this.invoiceId;
	}
	public void setInvoiceId(String invoiceId) {
		this.invoiceId = invoiceId;
	}

	public String getLastModifier() {
		return this.lastModifier;
	}
	public void setLastModifier(String lastModifier) {
		this.lastModifier = lastModifier;
	}

	public String getMailDate() {
		return this.mailDate;
	}
	public void setMailDate(String mailDate) {
		this.mailDate = mailDate;
	}

	public String getMailId() {
		return this.mailId;
	}
	public void setMailId(String mailId) {
		this.mailId = mailId;
	}

	public String getMailType() {
		return this.mailType;
	}
	public void setMailType(String mailType) {
		this.mailType = mailType;
	}

	public String getReason() {
		return this.reason;
	}
	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getRecipientsAddress() {
		return this.recipientsAddress;
	}
	public void setRecipientsAddress(String recipientsAddress) {
		this.recipientsAddress = recipientsAddress;
	}

	public String getRecipientsName() {
		return this.recipientsName;
	}
	public void setRecipientsName(String recipientsName) {
		this.recipientsName = recipientsName;
	}

	public String getRecipientsTel() {
		return this.recipientsTel;
	}
	public void setRecipientsTel(String recipientsTel) {
		this.recipientsTel = recipientsTel;
	}

	public String getSenderAddress() {
		return this.senderAddress;
	}
	public void setSenderAddress(String senderAddress) {
		this.senderAddress = senderAddress;
	}

	public String getSenderName() {
		return this.senderName;
	}
	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}

	public String getSenderTel() {
		return this.senderTel;
	}
	public void setSenderTel(String senderTel) {
		this.senderTel = senderTel;
	}

	public String getTntInstId() {
		return this.tntInstId;
	}
	public void setTntInstId(String tntInstId) {
		this.tntInstId = tntInstId;
	}

	public String getTrackingNo() {
		return this.trackingNo;
	}
	public void setTrackingNo(String trackingNo) {
		this.trackingNo = trackingNo;
	}

}
