package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * AP对账单发票关联明细
 *
 * @author auto create
 * @since 1.0, 2019-12-17 10:07:09
 */
public class ApInvoiceBillLinkOpenApiResponse extends AlipayObject {

	private static final long serialVersionUID = 3283833777768644593L;

	/**
	 * 开票金额
	 */
	@ApiField("amt")
	private MultiCurrencyMoneyOpenApi amt;

	/**
	 * 可开票对账单号
	 */
	@ApiField("bill_no")
	private String billNo;

	/**
	 * 创建人
	 */
	@ApiField("creator")
	private String creator;

	/**
	 * 日账单选择维度
	 */
	@ApiField("daily_bill_dimension")
	private String dailyBillDimension;

	/**
	 * 创建时间 ms
	 */
	@ApiField("gmt_create")
	private Date gmtCreate;

	/**
	 * 修改时间
	 */
	@ApiField("gmt_modified")
	private Date gmtModified;

	/**
	 * 发票id
	 */
	@ApiField("invoice_id")
	private String invoiceId;

	/**
	 * 最近修改人
	 */
	@ApiField("last_moder")
	private String lastModer;

	/**
	 * 关联明细号
	 */
	@ApiField("link_id")
	private String linkId;

	/**
	 * 税损金额
	 */
	@ApiField("tax_loss_amt")
	private MultiCurrencyMoneyOpenApi taxLossAmt;

	/**
	 * 租户机构id
	 */
	@ApiField("tnt_inst_id")
	private String tntInstId;

	public MultiCurrencyMoneyOpenApi getAmt() {
		return this.amt;
	}
	public void setAmt(MultiCurrencyMoneyOpenApi amt) {
		this.amt = amt;
	}

	public String getBillNo() {
		return this.billNo;
	}
	public void setBillNo(String billNo) {
		this.billNo = billNo;
	}

	public String getCreator() {
		return this.creator;
	}
	public void setCreator(String creator) {
		this.creator = creator;
	}

	public String getDailyBillDimension() {
		return this.dailyBillDimension;
	}
	public void setDailyBillDimension(String dailyBillDimension) {
		this.dailyBillDimension = dailyBillDimension;
	}

	public Date getGmtCreate() {
		return this.gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return this.gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getInvoiceId() {
		return this.invoiceId;
	}
	public void setInvoiceId(String invoiceId) {
		this.invoiceId = invoiceId;
	}

	public String getLastModer() {
		return this.lastModer;
	}
	public void setLastModer(String lastModer) {
		this.lastModer = lastModer;
	}

	public String getLinkId() {
		return this.linkId;
	}
	public void setLinkId(String linkId) {
		this.linkId = linkId;
	}

	public MultiCurrencyMoneyOpenApi getTaxLossAmt() {
		return this.taxLossAmt;
	}
	public void setTaxLossAmt(MultiCurrencyMoneyOpenApi taxLossAmt) {
		this.taxLossAmt = taxLossAmt;
	}

	public String getTntInstId() {
		return this.tntInstId;
	}
	public void setTntInstId(String tntInstId) {
		this.tntInstId = tntInstId;
	}

}
