package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 应付发票金额信息
 *
 * @author auto create
 * @since 1.0, 2019-12-12 18:17:34
 */
public class ApInvoiceAmtInfoOpenApiResponse extends AlipayObject {

	private static final long serialVersionUID = 4484723396936917537L;

	/**
	 * 发票类型对应的发票可开票金额和税损信息，没有时为空集合
	 */
	@ApiListField("ap_monthly_bill_loss_amt_rels")
	@ApiField("ap_monthly_bill_loss_amt_open_api_response")
	private List<ApMonthlyBillLossAmtOpenApiResponse> apMonthlyBillLossAmtRels;

	/**
	 * 发票类型
01 增值税专用发票
02 增值税普通发票
05 其它发票
07 虚拟发票(无法收票时使用)
	 */
	@ApiField("invoice_type")
	private String invoiceType;

	/**
	 * 发票类型中文描述:增值税专用发票/ 增值税普通发票/ 其它发票/虚拟发票(无法收票时使用)
	 */
	@ApiField("invoice_type_name")
	private String invoiceTypeName;

	public List<ApMonthlyBillLossAmtOpenApiResponse> getApMonthlyBillLossAmtRels() {
		return this.apMonthlyBillLossAmtRels;
	}
	public void setApMonthlyBillLossAmtRels(List<ApMonthlyBillLossAmtOpenApiResponse> apMonthlyBillLossAmtRels) {
		this.apMonthlyBillLossAmtRels = apMonthlyBillLossAmtRels;
	}

	public String getInvoiceType() {
		return this.invoiceType;
	}
	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}

	public String getInvoiceTypeName() {
		return this.invoiceTypeName;
	}
	public void setInvoiceTypeName(String invoiceTypeName) {
		this.invoiceTypeName = invoiceTypeName;
	}

}
